/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.GregTechAPI;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.GTUtility;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class GTHashSet
extends AbstractSet<GTItemStack> {
    private static final Object OBJECT = new Object();
    private final transient HashMap<GTItemStack, Object> map;

    public GTHashSet() {
        this.map = new HashMap();
        GregTechAPI.sItemStackMappings.add(this.map);
    }

    public GTHashSet(Collection<GTItemStack> c) {
        this.map = new HashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
        GregTechAPI.sItemStackMappings.add(this.map);
    }

    public GTHashSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
        GregTechAPI.sItemStackMappings.add(this.map);
    }

    public GTHashSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
        GregTechAPI.sItemStackMappings.add(this.map);
    }

    GTHashSet(int initialCapacity, float loadFactor, boolean dummy) {
        this.map = new LinkedHashMap<GTItemStack, Object>(initialCapacity, loadFactor);
        GregTechAPI.sItemStackMappings.add(this.map);
    }

    public Map<GTItemStack, Object> getMap() {
        return this.map;
    }

    @Override
    @Nonnull
    public Iterator<GTItemStack> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        return this.map.put(new GTItemStack(aStack), OBJECT) == null;
    }

    @Override
    public boolean add(GTItemStack e) {
        return this.map.put(e, OBJECT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == OBJECT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

