/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.common.items.SimpleSubItemClass;
import bartworks.util.MathUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEThoriumHighTempReactor
extends MTEEnhancedMultiBlockBase<MTEThoriumHighTempReactor>
implements ISurvivalConstructable {
    private static final int BASECASINGINDEX = 44;
    private int mCasingAmount = 0;
    private static final int HELIUM_NEEDED = 730000;
    private static final int powerUsage = (int)TierEU.RECIPE_IV / 2;
    private static final int maxCapacity = 675000;
    private static final int minCapacityToStart = 100000;
    private int HeliumSupply;
    private int fuelSupply;
    private boolean emptyingMode;
    private int coolingPerTick = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEThoriumHighTempReactor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"  BBBBBBB  ", " BBBBBBBBB ", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", " BBBBBBBBB ", "  BBBBBBB  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  bbb~bbb  ", " bbbbbbbbb ", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", " bbbbbbbbb ", "  bbbbbbb  "}})).addElement('c', StructureUtility.onElementPass(x -> ++x.mCasingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)12))).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEThoriumHighTempReactor.class).atLeast(HatchElement.Energy, HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.Maintenance).dot(1).casingIndex(44).build(), StructureUtility.onElementPass(x -> ++x.mCasingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)12))})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEThoriumHighTempReactor.class).atLeast(HatchElement.InputHatch, HatchElement.InputBus).dot(2).casingIndex(44).build(), StructureUtility.onElementPass(x -> ++x.mCasingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)12))})).build();

    public MTEThoriumHighTempReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private MTEThoriumHighTempReactor(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEThoriumHighTempReactor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("High Temperature Reactor, THTR").addInfo("Needs to be primed with " + GTUtility.formatNumbers(730000L) + " of helium").addInfo("Needs a constant supply of " + EnumChatFormatting.AQUA + "coolant" + EnumChatFormatting.GRAY + " while running").addInfo("Needs at least " + EnumChatFormatting.GOLD + "100K" + EnumChatFormatting.GRAY + " Fuel pebbles to start operation (can hold up to 675k pebbles)").addInfo("Consumes up to " + EnumChatFormatting.GOLD + "0.5%" + EnumChatFormatting.GRAY + " of total Fuel Pellets per Operation depending on efficiency").addInfo("Efficiency decreases exponentially if the internal buffer is not completely filled").addInfo("Reactor will take " + EnumChatFormatting.AQUA + "4800L/t" + EnumChatFormatting.GRAY + " of coolant multiplied by efficiency").addInfo("Uses " + GTUtility.formatNumbers(powerUsage) + " EU/t").addInfo("One Operation takes 9 hours").beginStructureBlock(11, 12, 11, true).addController("Front bottom center").addCasingInfoMin("Radiation Proof Casings", 500, false).addStructureInfo("Corners and the 2 touching blocks are air (cylindric)").addInputBus("Any top layer casing", 2).addInputHatch("Any top layer casing", 2).addOutputBus("Any bottom layer casing", 1).addOutputHatch("Any bottom layer casing", 1).addEnergyHatch("Any bottom layer casing", 1).addMaintenanceHatch("Any bottom layer casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 11, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 5, 11, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 11, 0) && this.mCasingAmount >= 500 && this.mMaintenanceHatches.size() == 1 && !this.mInputHatches.isEmpty() && !this.mOutputHatches.isEmpty() && !this.mInputBusses.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.HeliumSupply = aNBT.func_74762_e("HeliumSupply");
        this.fuelSupply = aNBT.func_74762_e("fuelsupply");
        this.coolingPerTick = aNBT.func_74762_e("coolanttaking");
        this.emptyingMode = aNBT.func_74767_n("EmptyMode");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("HeliumSupply", this.HeliumSupply);
        aNBT.func_74768_a("fuelsupply", this.fuelSupply);
        aNBT.func_74768_a("coolanttaking", this.coolingPerTick);
        aNBT.func_74757_a("EmptyMode", this.emptyingMode);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && !this.emptyingMode) {
            int toget;
            if (this.HeliumSupply < 730000) {
                for (FluidStack fluidStack : this.getStoredFluids()) {
                    if (!fluidStack.isFluidEqual(Materials.Helium.getGas(1L))) continue;
                    toget = Math.min(730000 - this.HeliumSupply, fluidStack.amount);
                    fluidStack.amount -= toget;
                    this.HeliumSupply += toget;
                }
            }
            if (this.fuelSupply < 675000) {
                this.startRecipeProcessing();
                for (ItemStack itemStack : this.getStoredInputs()) {
                    if (!GTUtility.areStacksEqual(itemStack, new ItemStack((Item)THTRMaterials.aTHTR_Materials, 1, 4)) || (toget = Math.min(675000 - this.fuelSupply, itemStack.field_77994_a)) == 0) continue;
                    itemStack.field_77994_a -= toget;
                    this.fuelSupply += toget;
                }
                this.endRecipeProcessing();
                this.updateSlots();
            }
        }
    }

    private double getEfficiency() {
        double base = (double)(this.fuelSupply - 100000) / 57500.0;
        return Math.min(base * base + 1.0, 100.0) / 100.0 - (double)(this.getIdealStatus() - this.getRepairStatus()) / 10.0;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.emptyingMode) {
            if (this.HeliumSupply <= 0 && this.fuelSupply <= 0) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            this.mEfficiency = 10000;
            this.mMaxProgresstime = 100;
        } else {
            int meta;
            ItemStack[] toOutput;
            int toReduce;
            if (this.HeliumSupply < 730000 || this.fuelSupply < 100000) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            double efficiency = this.getEfficiency();
            if (efficiency <= 0.0) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            int originalToReduce = toReduce = MathUtils.floorInt((double)this.fuelSupply * 0.005 * efficiency);
            int burnedBalls = toReduce / 64;
            if (burnedBalls > 0) {
                toReduce -= burnedBalls * 64;
            }
            if (!this.canOutputAll(toOutput = new ItemStack[]{new ItemStack((Item)THTRMaterials.aTHTR_Materials, burnedBalls, meta = 5), new ItemStack((Item)THTRMaterials.aTHTR_Materials, toReduce, meta + 1)})) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            this.fuelSupply -= originalToReduce;
            this.mOutputItems = toOutput;
            this.coolingPerTick = (int)(4800.0 * efficiency);
            this.mEfficiency = (int)(efficiency * 10000.0);
            this.mEUt = -powerUsage;
            this.mMaxProgresstime = 648000;
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.emptyingMode) {
            this.addOutput(Materials.Helium.getGas(this.HeliumSupply));
            this.addOutput(new ItemStack((Item)THTRMaterials.aTHTR_Materials, this.fuelSupply, 4));
            this.HeliumSupply = 0;
            this.fuelSupply = 0;
            this.updateSlots();
            return true;
        }
        if (!super.onRunningTick(aStack)) {
            return false;
        }
        int takecoolant = this.coolingPerTick;
        int drainedamount = 0;
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            FluidStack tLiquid = tHatch.getFluid();
            if (tLiquid == null || !tLiquid.isFluidEqual(GTModHandler.getIC2Coolant(1L))) continue;
            FluidStack drained = tHatch.drain(takecoolant, true);
            drainedamount += drained.amount;
            if ((takecoolant -= drained.amount) > 0) continue;
            break;
        }
        if (drainedamount > 0) {
            this.addOutput(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)drainedamount));
        }
        this.updateSlots();
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEThoriumHighTempReactor(this.mName);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"BW.infoData.thtr.progress", (Object[])new Object[]{GTUtility.formatNumbers(this.mProgresstime / 20), GTUtility.formatNumbers(this.mMaxProgresstime / 20)}), StatCollector.func_74837_a((String)"BW.infoData.thtr.triso_pebbles", (Object[])new Object[]{GTUtility.formatNumbers(this.fuelSupply), GTUtility.formatNumbers(this.fuelSupply)}), StatCollector.func_74837_a((String)"BW.infoData.htr.helium_level", (Object[])new Object[]{GTUtility.formatNumbers(this.HeliumSupply), GTUtility.formatNumbers(730000L)}), StatCollector.func_74837_a((String)"BW.infoData.thtr.coolant", (Object[])new Object[]{GTUtility.formatNumbers(this.mProgresstime == 0 ? 0L : (long)this.coolingPerTick)}), StatCollector.func_74837_a((String)"BW.infoData.htr.problems", (Object[])new Object[]{String.valueOf(this.getIdealStatus() - this.getRepairStatus())})};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(44), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(44), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(44)};
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.mMaxProgresstime > 0) {
            GTUtility.sendChatToPlayer(aPlayer, "THTR mode cannot be changed while the machine is running.");
            return;
        }
        this.emptyingMode = !this.emptyingMode;
        GTUtility.sendChatToPlayer(aPlayer, "THTR is now running in " + (this.emptyingMode ? "emptying mode." : "normal Operation"));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    public static class THTRMaterials {
        public static final SimpleSubItemClass aTHTR_Materials = new SimpleSubItemClass("BISOPelletCompound", "BISOPelletBall", "TRISOPelletCompound", "TRISOPelletBall", "TRISOPellet", "BurnedOutTRISOPelletBall", "BurnedOutTRISOPellet");
        public static final int MATERIAL_FUEL_INDEX = 4;
        public static final int MATERIAL_USED_FUEL_INDEX = 5;

        public static void registeraTHR_Materials() {
            GameRegistry.registerItem((Item)aTHTR_Materials, (String)"bw.THTRMaterials");
        }
    }
}

