/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.fml;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public abstract class AClassTransformer {
    protected static final String InstanceConstructorName = "<init>";
    private static Printer asmPrinter = new Textifier();
    private static TraceMethodVisitor asmVisitor = new TraceMethodVisitor(asmPrinter);
    public final String classCanonicalName;

    protected AClassTransformer(String classCanonicalName) {
        this.classCanonicalName = classCanonicalName;
    }

    protected AbstractInsnNode findFirstOpCode(InsnList instructions, int opcode) {
        for (int index = 0; index < instructions.size(); ++index) {
            if (instructions.get(index).getOpcode() != opcode) continue;
            return instructions.get(index);
        }
        return null;
    }

    protected AbstractInsnNode findLastOpCode(InsnList instructions, int opcode) {
        for (int index = instructions.size() - 1; index > 0; --index) {
            if (instructions.get(index).getOpcode() != opcode) continue;
            return instructions.get(index);
        }
        return null;
    }

    protected AbstractInsnNode findLastType(InsnList instructions, int type, int skip) {
        for (int index = instructions.size() - 1; index > 0; --index) {
            if (instructions.get(index).getType() != type || --skip >= 0) continue;
            return instructions.get(index);
        }
        return null;
    }

    protected AbstractInsnNode findNextOpCode(AbstractInsnNode fromInstruction, int opcode) {
        AbstractInsnNode nextInsn = fromInstruction;
        do {
            if (nextInsn.getOpcode() != opcode) continue;
            return nextInsn;
        } while ((nextInsn = nextInsn.getNext()) != null);
        return null;
    }

    protected AbstractInsnNode findSequence(InsnList instructions, int[] opSequence, boolean skipNons) {
        int seqIndex = 0;
        AbstractInsnNode insertionPoint = null;
        for (int index = 0; index < instructions.size(); ++index) {
            AbstractInsnNode ins = instructions.get(index);
            if (skipNons && ins.getOpcode() == -1) continue;
            if (ins.getOpcode() == opSequence[seqIndex]) {
                if (++seqIndex != opSequence.length) continue;
                insertionPoint = ins;
                break;
            }
            seqIndex = ins.getOpcode() == opSequence[0] ? 1 : 0;
        }
        return insertionPoint;
    }

    protected void log(String text) {
        FMLRelaunchLog.log((String)"ThE-Core", (Level)Level.INFO, (String)text, (Object[])new Object[0]);
    }

    protected void logInstructionDetails(AbstractInsnNode insn) {
        insn.accept((MethodVisitor)asmVisitor);
        StringWriter sw = new StringWriter();
        asmPrinter.print(new PrintWriter(sw));
        asmPrinter.getText().clear();
        this.log(sw.toString());
    }

    protected abstract void onTransformFailure();

    protected abstract void transform(ClassNode var1);

    public final byte[] transformClass(byte[] classBytes) {
        try {
            this.log(String.format("Transforming Class (%s)", this.classCanonicalName));
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept((ClassVisitor)classNode, 0);
            this.transform(classNode);
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Exception e) {
            this.log(String.format("Unable to transform (%s)", this.classCanonicalName));
            this.onTransformFailure();
            return classBytes;
        }
    }
}

