/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import thaumicenergistics.api.entities.IGolemHookHandler;
import thaumicenergistics.api.entities.IGolemHookSyncRegistry;
import thaumicenergistics.common.utils.ThELog;

class GolemSyncRegistry
implements IGolemHookSyncRegistry {
    private static final HashMap<Integer, IGolemHookHandler> handlerMappings = new HashMap();
    private final HashMap<Integer, Character> dataMappings = new HashMap();
    private Integer uuid = 13;
    private boolean hasDataChanged = false;
    public boolean canRegister = false;
    public String lastUpdatedFrom = null;
    public float clientSyncTicks = 0.0f;

    GolemSyncRegistry() {
    }

    public void copyDefaults(GolemSyncRegistry defaults) {
        this.dataMappings.clear();
        this.dataMappings.putAll(defaults.dataMappings);
        this.hasDataChanged = true;
    }

    @Override
    public char getSyncCharOrDefault(int id, char defaultChar) {
        return this.dataMappings.getOrDefault(id, Character.valueOf(defaultChar)).charValue();
    }

    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String mappingsToString() {
        this.hasDataChanged = false;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(this.dataMappings.size() * 6 + 4);){
            String string;
            try (DataOutputStream stream = new DataOutputStream(baos);){
                stream.writeInt(this.dataMappings.size());
                for (Map.Entry<Integer, Character> entry : this.dataMappings.entrySet()) {
                    stream.writeInt(entry.getKey());
                    stream.writeChar(entry.getValue().charValue());
                }
                stream.close();
                string = baos.toString(Charsets.UTF_8.name());
            }
            return string;
        }
        catch (IOException e) {
            ThELog.error(e, "Unable to send golem sync data", new Object[0]);
            return "";
        }
    }

    public void markDirty() {
        this.hasDataChanged = true;
    }

    public HashSet<IGolemHookHandler> readFromString(String data) {
        if (data == null || data.length() < 4) {
            ThELog.warning("Incomplete golem sync data received", new Object[0]);
            return null;
        }
        HashSet<IGolemHookHandler> handlersToUpdate = new HashSet<IGolemHookHandler>();
        this.hasDataChanged = false;
        this.lastUpdatedFrom = data;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes(Charsets.UTF_8.name()));
             DataInputStream stream = new DataInputStream(bais);){
            int count = stream.readInt();
            for (int i = 0; i < count; ++i) {
                Integer id = stream.readInt();
                Character c = Character.valueOf(stream.readChar());
                this.dataMappings.put(id, c);
                handlersToUpdate.add(handlerMappings.get(id));
            }
            stream.close();
        }
        catch (Exception e) {
            ThELog.error(e, "Malformed golem sync data received", new Object[0]);
        }
        if (!handlersToUpdate.isEmpty()) {
            return handlersToUpdate;
        }
        return null;
    }

    @Override
    public int registerSyncChar(IGolemHookHandler handler, char c) {
        if (!this.canRegister) {
            throw new UnsupportedOperationException("Can not register new sync data at this location.");
        }
        this.dataMappings.put(this.uuid, Character.valueOf(c));
        handlerMappings.put(this.uuid, handler);
        this.hasDataChanged = true;
        int id = this.uuid;
        this.uuid = id + 1;
        return id;
    }

    @Override
    public void updateSyncChar(IGolemHookHandler handler, int id, char c) {
        Integer ID = id;
        if (!this.dataMappings.containsKey(ID)) {
            throw new UnsupportedOperationException("Unable to update sync byte '" + Integer.toString(id) + "', that ID is not mapped");
        }
        IGolemHookHandler registeredHandler = handlerMappings.get(ID);
        if (registeredHandler != handler) {
            throw new UnsupportedOperationException("Unable to update sync byte '" + Integer.toString(id) + "', that ID does not belong to you.");
        }
        Character newValue = Character.valueOf(c);
        if (this.dataMappings.put(ID, newValue) != newValue) {
            this.hasDataChanged = true;
        }
    }
}

