/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EntityUtil {
    private static final Random rand = new Random();

    public static void setEntityVelocity(Entity entity, double velX, double velY, double velZ) {
        entity.field_70159_w = velX;
        entity.field_70181_x = velY;
        entity.field_70179_y = velZ;
    }

    public static EntityFireworkRocket getRandomFirework(World world) {
        return EntityUtil.getRandomFirework(world, new BlockCoord(0, 0, 0));
    }

    public static EntityFireworkRocket getRandomFirework(World world, BlockCoord pos) {
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.field_77990_d = new NBTTagCompound();
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[rand.nextInt(16)];
        }
        expl.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        expl.func_74774_a("Type", type);
        NBTTagList explosions = new NBTTagList();
        explosions.func_74742_a((NBTBase)expl);
        NBTTagCompound fireworkTag = new NBTTagCompound();
        fireworkTag.func_74782_a("Explosions", (NBTBase)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.field_77990_d.func_74782_a("Fireworks", (NBTBase)fireworkTag);
        EntityFireworkRocket e = new EntityFireworkRocket(world, (double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, firework);
        return e;
    }

    public static void spawnFirework(BlockCoord block, int dimID) {
        EntityUtil.spawnFirework(block, dimID, 0);
    }

    public static void spawnFirework(BlockCoord block, int dimID, int range) {
        WorldServer world = DimensionManager.getWorld((int)dimID);
        BlockCoord pos = new BlockCoord(block.x, block.y, block.z);
        if (range > 0) {
            pos = new BlockCoord(EntityUtil.moveRandomly(block.x, range), (double)block.y, EntityUtil.moveRandomly(block.z, range));
            int tries = -1;
            while (!world.func_147437_c(pos.x, pos.y, pos.z) && !world.func_147439_a(pos.x, pos.y, pos.z).isReplaceable((IBlockAccess)world, pos.x, pos.y, pos.z)) {
                if (++tries <= 100) continue;
                return;
            }
        }
        world.func_72838_d((Entity)EntityUtil.getRandomFirework((World)world, pos));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + rand.nextDouble() * range - range / 2.0;
    }

    public static String getDisplayNameForEntity(String mobName) {
        return StatCollector.func_74838_a((String)("entity." + mobName + ".name"));
    }

    public static List<String> getAllRegisteredMobNames(boolean excludeBosses) {
        ArrayList<String> result = new ArrayList<String>();
        Set entries = EntityList.field_75626_c.entrySet();
        for (Map.Entry entry : entries) {
            if (!EntityLiving.class.isAssignableFrom((Class)entry.getKey()) || excludeBosses && IBossDisplayData.class.isAssignableFrom((Class)entry.getKey())) continue;
            result.add((String)entry.getValue());
        }
        return result;
    }

    private EntityUtil() {
    }

    public static Vector3d getEntityPosition(Entity ent) {
        return new Vector3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }

    public static List<AxisAlignedBB> getCollidingBlockGeometry(World world, Entity entity) {
        AxisAlignedBB entityBounds = entity.field_70121_D;
        ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList<AxisAlignedBB>();
        int minX = MathHelper.func_76128_c((double)entityBounds.field_72340_a);
        int minY = MathHelper.func_76128_c((double)entityBounds.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)entityBounds.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)(entityBounds.field_72336_d + 1.0));
        int maxY = MathHelper.func_76128_c((double)(entityBounds.field_72337_e + 1.0));
        int maxZ = MathHelper.func_76128_c((double)(entityBounds.field_72334_f + 1.0));
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == null) continue;
                    block.func_149743_a(world, x, y, z, entityBounds, collidingBoundingBoxes, entity);
                }
            }
        }
        return collidingBoundingBoxes;
    }

    public static void spawnItemInWorldWithRandomMotion(World world, ItemStack item, int x, int y, int z) {
        if (item != null) {
            EntityUtil.spawnItemInWorldWithRandomMotion(world, item, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
    }

    public static void spawnItemInWorldWithRandomMotion(World world, ItemStack item, double x, double y, double z) {
        if (item != null) {
            EntityUtil.spawnItemInWorldWithRandomMotion(new EntityItem(world, x, y, z, item));
        }
    }

    public static void spawnItemInWorldWithRandomMotion(EntityItem entity) {
        entity.field_145804_b = 10;
        float f = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        float f1 = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        float f2 = entity.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f;
        entity.field_70159_w += (double)f;
        entity.field_70181_x += (double)f1;
        entity.field_70179_y += (double)f2;
        entity.field_70170_p.func_72838_d((Entity)entity);
    }
}

