/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.container.AEBaseContainer;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public abstract class GuiAmount
extends AEBaseGui {
    protected MEGuiTextField amountTextField;
    protected GuiTabButton originalGuiBtn;
    protected GuiButton nextBtn;
    protected GuiButton plus1;
    protected GuiButton plus10;
    protected GuiButton plus100;
    protected GuiButton plus1000;
    protected GuiButton minus1;
    protected GuiButton minus10;
    protected GuiButton minus100;
    protected GuiButton minus1000;
    protected GuiBridge originalGui;
    protected ItemStack myIcon;

    public GuiAmount(Container container) {
        super(container);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int a = this.getButtonQtyByIndex(0);
        int b = this.getButtonQtyByIndex(1);
        int c = this.getButtonQtyByIndex(2);
        int d = this.getButtonQtyByIndex(3);
        this.plus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 26, 22, 20, "+" + a);
        this.field_146292_n.add(this.plus1);
        this.plus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 26, 28, 20, "+" + b);
        this.field_146292_n.add(this.plus10);
        this.plus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 26, 32, 20, "+" + c);
        this.field_146292_n.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 26, 38, 20, "+" + d);
        this.field_146292_n.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 75, 22, 20, "-" + a);
        this.field_146292_n.add(this.minus1);
        this.minus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 75, 28, 20, "-" + b);
        this.field_146292_n.add(this.minus10);
        this.minus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 75, 32, 20, "-" + c);
        this.field_146292_n.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 75, 38, 20, "-" + d);
        this.field_146292_n.add(this.minus1000);
        this.nextBtn = new GuiButton(0, this.field_147003_i + 128, this.field_147009_r + 51, 38, 20, GuiText.Next.getLocal());
        this.field_146292_n.add(this.nextBtn);
        Object target = ((AEBaseContainer)this.field_147002_h).getTarget();
        this.setOriginGUI(target);
        if (this.originalGui != null && this.myIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, this.myIcon, this.myIcon.func_82833_r(), field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
        }
        this.amountTextField = new MEGuiTextField(61, 12);
        this.amountTextField.x = this.field_147003_i + 60;
        this.amountTextField.y = this.field_147009_r + 55;
        this.amountTextField.setMaxStringLength(16);
        this.amountTextField.setFocused(true);
    }

    protected abstract void setOriginGUI(Object var1);

    protected int getButtonQtyByIndex(int index) {
        return AEConfig.instance.craftItemsByStackAmounts(index);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture(this.getBackground());
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (key == 28 || key == 156) {
                this.func_146284_a(this.nextBtn);
            }
            this.amountTextField.textboxKeyTyped(character, key);
            super.func_73869_a(character, key);
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        super.func_73864_a(xCoord, yCoord, btn);
        this.amountTextField.mouseClickedNoFocusDrop(xCoord, yCoord, btn);
    }

    protected void func_146284_a(GuiButton btn) {
        boolean isMinus;
        super.func_146284_a(btn);
        if (btn == this.originalGuiBtn) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.originalGui));
        }
        boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
        boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
        if (isPlus || isMinus) {
            this.addAmount(this.getQty(btn));
        }
    }

    protected void addAmount(int i) {
        long resultL = this.getAmountLong();
        if (resultL == 1L && i > 1) {
            resultL = 0L;
        }
        if ((resultL += (long)i) < 1L) {
            resultL = 1L;
        }
        this.amountTextField.setText(Long.toString(resultL));
        this.amountTextField.setCursorPositionEnd();
    }

    protected int getAmount() {
        String out = this.amountTextField.getText();
        double resultD = Calculator.conversion(out);
        if (resultD <= 0.0 || Double.isNaN(resultD)) {
            return 0;
        }
        return (int)ArithHelper.round(resultD, 0);
    }

    protected long getAmountLong() {
        String out = this.amountTextField.getText();
        double resultD = Calculator.conversion(out);
        if (resultD <= 0.0 || Double.isNaN(resultD)) {
            return 0L;
        }
        return (long)ArithHelper.round(resultD, 0);
    }

    protected abstract String getBackground();
}

