/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.text.action.SelectLineAction;
import com.github.weisj.darklaf.ui.text.action.SelectWordAction;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighterDark.DarkHighlightPainter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;

public class DarkCaret
extends DefaultCaret
implements UIResource {
    private static final Logger LOGGER = LogUtil.getLogger(DarkCaret.class);
    private static final int FLAG_SIZE = 3;
    private static final Action selectWord = new SelectWordAction();
    private static final Action selectLine = new SelectLineAction();
    private final Segment seg;
    private final DarkHighlightPainter selectionPainter;
    private MouseEvent selectedWordEvent;
    private CaretStyle style;
    private CaretStyle insertStyle;
    private boolean alwaysVisible;
    private boolean pasteOnMiddleMouseClick;
    private boolean insertMode;
    private boolean expandMode;
    private boolean dotLtr = true;
    private final int[] flagXPoints = new int[3];
    private final int[] flagYPoints = new int[3];

    public DarkCaret() {
        this((CaretStyle)null, (CaretStyle)null);
    }

    public DarkCaret(CaretStyle style, CaretStyle insertStyle) {
        this.seg = new Segment();
        this.setStyles(style, insertStyle);
        this.selectionPainter = new DarkHighlightPainter();
        this.pasteOnMiddleMouseClick = true;
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(boolean insertMode) {
        if (this.insertMode != insertMode) {
            this.insertMode = insertMode;
            this.repaint();
        }
    }

    public void setExpandMode(boolean expandMode) {
        this.expandMode = expandMode;
    }

    @Override
    public int getMark() {
        int mark = super.getMark();
        int dot = super.getDot();
        JTextComponent target = this.getComponent();
        if (this.expandMode && this.isInsertMode() && target != null && mark == dot && !this.isEndOfLine(target, dot)) {
            ++mark;
        }
        return mark;
    }

    private boolean isEndOfLine(JTextComponent target, int dot) {
        Document doc = target.getDocument();
        if (dot >= doc.getLength()) {
            return true;
        }
        try {
            return target.getText(dot, 1).equals("\n");
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public boolean getRoundedSelectionEdges() {
        return this.getDarkSelectionPainter().getRoundedEdges();
    }

    public void setRoundedSelectionEdges(boolean rounded) {
        this.getDarkSelectionPainter().setRoundedEdges(rounded);
    }

    public boolean isExtendingEnabled() {
        return this.getDarkSelectionPainter().isLineExtendingEnabled();
    }

    public void setLineExtendingEnabled(boolean enabled) {
        this.getDarkSelectionPainter().setLineExtendingEnabled(enabled);
    }

    public CaretStyle getEffectiveStyle() {
        return this.isInsertMode() ? this.insertStyle : this.style;
    }

    public CaretStyle getStyle() {
        return this.style;
    }

    public CaretStyle getInsertStyle() {
        return this.insertStyle;
    }

    public void setStyle(CaretStyle style) {
        CaretStyle s = style;
        if (s == null) {
            s = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        if (s != this.style) {
            this.style = s;
            this.repaint();
        }
    }

    public void setInsertStyle(CaretStyle insertStyle) {
        CaretStyle is = insertStyle;
        if (is == null) {
            is = CaretStyle.BLOCK_BORDER_STYLE;
        }
        if (is != this.insertStyle) {
            this.insertStyle = is;
            this.repaint();
        }
    }

    public void setStyles(CaretStyle style, CaretStyle insertStyle) {
        this.setInsertStyle(insertStyle);
        this.setStyle(style);
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        if (alwaysVisible != this.alwaysVisible) {
            this.alwaysVisible = alwaysVisible;
            if (!this.isVisible()) {
                this.repaint();
            }
        }
    }

    @Override
    public double getWidth() {
        return this.getEffectiveStyle().getSize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isConsumed()) {
            JTextComponent c;
            JTextComponent textArea = this.getComponent();
            int clickCount = e.getClickCount();
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (clickCount > 2) {
                    switch (clickCount %= 2) {
                        case 0: {
                            this.selectWord(e);
                            this.selectedWordEvent = null;
                            break;
                        }
                        case 1: {
                            selectLine.actionPerformed(new ActionEvent(textArea, 1001, null, e.getWhen(), e.getModifiersEx()));
                        }
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(e) && this.getPasteOnMiddleMouseClick() && clickCount == 1 && textArea.isEditable() && textArea.isEnabled() && (c = (JTextComponent)e.getSource()) != null) {
                try {
                    Toolkit tk = c.getToolkit();
                    Clipboard buffer = tk.getSystemSelection();
                    if (buffer != null) {
                        Transferable trans;
                        this.adjustCaretLocation(e);
                        TransferHandler th = c.getTransferHandler();
                        if (th != null && (trans = buffer.getContents(null)) != null) {
                            th.importData(c, trans);
                        }
                        this.adjustFocus(true);
                    } else {
                        textArea.paste();
                    }
                }
                catch (HeadlessException ignored) {
                    LOGGER.severe("Pasting in headless mode isn't supported");
                }
            }
        }
    }

    private void adjustCaretLocation(MouseEvent e) {
        if (e.isShiftDown() && this.getDot() != -1) {
            this.moveCaret(e);
        } else {
            this.positionCaret(e);
        }
    }

    private void adjustFocus(boolean inWindow) {
        JTextComponent textArea = this.getComponent();
        if (textArea != null && textArea.isEnabled() && textArea.isRequestFocusEnabled()) {
            if (inWindow) {
                textArea.requestFocusInWindow();
            } else {
                textArea.requestFocusInWindow();
            }
        }
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        if (r != null) {
            this.validateWidth(r);
            this.x = r.x - 1;
            this.y = r.y;
            this.width = r.width + 4;
            this.height = r.height;
            if (this.isBidiText() && !this.dotLtr) {
                this.x -= 3;
                this.width += 3;
            }
            this.repaint();
        }
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.getDarkSelectionPainter();
    }

    protected DarkHighlightPainter getDarkSelectionPainter() {
        return this.selectionPainter;
    }

    @Override
    public boolean isSelectionVisible() {
        return super.isSelectionVisible() && this.getDarkSelectionPainter().isEnabled();
    }

    public void setPaintSelectionHighlight(boolean paintSelectionHighlight) {
        this.getDarkSelectionPainter().setEnabled(paintSelectionHighlight);
    }

    public boolean getPasteOnMiddleMouseClick() {
        return this.pasteOnMiddleMouseClick;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTextComponent c;
        super.mousePressed(e);
        if (!e.isConsumed() && SwingUtilities.isRightMouseButton(e) && (c = this.getComponent()) != null && c.isEnabled() && c.isRequestFocusEnabled()) {
            c.requestFocusInWindow();
        }
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() || this.isAlwaysVisible();
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible()) {
            Rectangle r;
            JTextComponent textArea = this.getComponent();
            g.setColor(textArea.getCaretColor());
            TextUI mapper = textArea.getUI();
            try {
                r = mapper.modelToView(textArea, this.getDot(), this.getDotBias());
            }
            catch (BadLocationException ex) {
                r = new Rectangle(0, 0, 0, 0);
            }
            this.validateWidth(r);
            if (this.width > 0 && this.height > 0 && !this.contains(r.x, r.y, r.width, r.height)) {
                Rectangle clip = g.getClipBounds();
                if (clip != null && !clip.contains(this)) {
                    this.repaint();
                }
                this.damage(r);
            }
            r.height -= 2;
            ++r.y;
            Color textAreaBg = textArea.getBackground();
            if (textAreaBg == null) {
                textAreaBg = Color.white;
            }
            switch (this.getEffectiveStyle()) {
                case BLOCK_STYLE: {
                    g.setXORMode(textAreaBg);
                    g.fillRect(r.x, r.y, r.width, r.height);
                    break;
                }
                case BLOCK_BORDER_STYLE: {
                    PaintUtil.drawRect(g, r.x, r.y, r.width, r.height, this.getEffectiveStyle().getSize());
                    break;
                }
                case UNDERLINE_STYLE: {
                    g.setXORMode(textAreaBg);
                    int y = r.y + r.height;
                    g.fillRect(r.x, y - this.getEffectiveStyle().getSize(), r.width, this.getEffectiveStyle().getSize());
                    break;
                }
                case THICK_VERTICAL_LINE_STYLE: 
                case VERTICAL_LINE_STYLE: {
                    g.fillRect(r.x, r.y, this.style.getSize(), r.height);
                    if (!this.isBidiText()) break;
                    this.flagXPoints[0] = r.x + (this.dotLtr ? this.style.getSize() : 0);
                    this.flagYPoints[0] = r.y;
                    this.flagXPoints[1] = this.flagXPoints[0];
                    this.flagYPoints[1] = this.flagYPoints[0] + 3;
                    this.flagXPoints[2] = this.flagXPoints[0] + (this.dotLtr ? 3 : -3);
                    this.flagYPoints[2] = this.flagYPoints[0];
                    g.fillPolygon(this.flagXPoints, this.flagYPoints, 3);
                }
            }
        }
    }

    protected boolean isBidiText() {
        Document doc = this.getComponent().getDocument();
        if (doc instanceof AbstractDocument) {
            Element bidi = ((AbstractDocument)doc).getBidiRootElement();
            return bidi != null && bidi.getElementCount() > 1;
        }
        return false;
    }

    protected boolean isPositionLTR(int position, Position.Bias bias) {
        Document doc = this.getComponent().getDocument();
        if (bias == Position.Bias.Backward && --position < 0) {
            position = 0;
        }
        return DarkCaret.isLeftToRight(doc, position, position);
    }

    protected static boolean isLeftToRight(Document doc, int p0, int p1) {
        int index;
        AbstractDocument adoc;
        Element bidiRoot;
        Element bidiElem;
        if (Boolean.TRUE.equals(doc.getProperty("i18n")) && doc instanceof AbstractDocument && (bidiElem = (bidiRoot = (adoc = (AbstractDocument)doc).getBidiRootElement()).getElement(index = bidiRoot.getElementIndex(p0))).getEndOffset() >= p1) {
            AttributeSet bidiAttrs = bidiElem.getAttributes();
            return StyleConstants.getBidiLevel(bidiAttrs) % 2 == 0;
        }
        return true;
    }

    private void selectWord(MouseEvent e) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == e.getX() && this.selectedWordEvent.getY() == e.getY()) {
            return;
        }
        JTextComponent textArea = this.getComponent();
        selectWord.actionPerformed(new ActionEvent(textArea, 1001, null, e.getWhen(), e.getModifiersEx()));
        this.selectedWordEvent = e;
    }

    public void setPasteOnMiddleMouseClick(boolean paste) {
        this.pasteOnMiddleMouseClick = paste;
    }

    @Override
    public void setSelectionVisible(boolean visible) {
        super.setSelectionVisible(true);
    }

    private void validateWidth(Rectangle rect) {
        if (rect != null && (rect.width <= 1 || this.getEffectiveStyle().isCharacterWidth())) {
            JTextComponent textArea = this.getComponent();
            try {
                textArea.getDocument().getText(this.getDot(), 1, this.seg);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                rect.width = 8;
            }
            Font font = textArea.getFont();
            FontMetrics fm = textArea.getFontMetrics(font);
            rect.width = fm.charWidth(this.seg.array[this.seg.offset]);
            if (rect.width == 0) {
                rect.width = fm.charWidth(' ');
            }
        }
    }

    @Override
    public void setDot(int d, Position.Bias bias) {
        super.setDot(d, bias);
        this.updateDot(d, bias);
    }

    public void updateDot(int d, Position.Bias bias) {
        Document doc = this.getComponent().getDocument();
        int dot = d;
        Position.Bias dotBias = bias;
        if (doc != null) {
            dot = Math.min(dot, doc.getLength());
        }
        if ((dot = Math.max(dot, 0)) == 0) {
            dotBias = Position.Bias.Forward;
        }
        this.dotLtr = this.isPositionLTR(d, dotBias);
    }

    @Override
    public void moveDot(int dot, Position.Bias dotBias) {
        super.moveDot(dot, dotBias);
        this.updateDot(dot, dotBias);
    }

    public static enum CaretStyle {
        VERTICAL_LINE_STYLE(1, false),
        UNDERLINE_STYLE(1, true),
        BLOCK_STYLE(1, true),
        BLOCK_BORDER_STYLE(1, true),
        THICK_VERTICAL_LINE_STYLE(2, false);

        private final int size;
        private final boolean charWidth;

        private CaretStyle(int size, boolean charWidth) {
            this.size = size;
            this.charWidth = charWidth;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isCharacterWidth() {
            return this.charWidth;
        }
    }
}

