/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.compatibility.SwingUtil;
import com.github.weisj.darklaf.ui.DragRecognitionSupport;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public abstract class TableUIBridge
extends BasicTableUI {
    protected static final StringBuilder BASELINE_COMPONENT_KEY = new StringBuilder("Table.baselineComponent");
    protected boolean isFileList = false;

    protected static int getAdjustedLead(JTable table, boolean row) {
        return row ? TableUIBridge.getAdjustedLead(table, row, table.getSelectionModel()) : TableUIBridge.getAdjustedLead(table, row, table.getColumnModel().getSelectionModel());
    }

    protected static int getAdjustedLead(JTable table, boolean row, ListSelectionModel model) {
        int index = model.getLeadSelectionIndex();
        int compare = row ? table.getRowCount() : table.getColumnCount();
        return index < compare ? index : -1;
    }

    protected boolean pointOutsidePrefSize(int row, int column, Point p) {
        if (!this.isFileList) {
            return false;
        }
        return SwingUtil.pointOutsidePrefSize(this.table, row, column, p);
    }

    @Override
    public void installUI(JComponent c) {
        this.table = (JTable)c;
        super.installUI(c);
        this.table.remove(this.rendererPane);
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.isFileList = PropertyUtil.getBooleanProperty(this.table, "Table.isFileList");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addPropertyChangeListener(this.getHandler());
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return this.getHandler();
    }

    protected abstract Handler getHandler();

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)UIManager.get("Table.ancestorInputMap", this.table.getLocale());
            if (this.table.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("Table.ancestorInputMap.RightToLeft", this.table.getLocale())) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    @Override
    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
    }

    @Override
    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.getHandler());
        if (this.isFileList) {
            this.table.getSelectionModel().removeListSelectionListener(this.getHandler());
        }
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    @Override
    public abstract void paint(Graphics var1, JComponent var2);

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        Component renderer = (Component)lafDefaults.get(BASELINE_COMPONENT_KEY);
        if (renderer == null) {
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
            renderer = tcr.getTableCellRendererComponent(this.table, "a", false, false, -1, -1);
            lafDefaults.put(BASELINE_COMPONENT_KEY, renderer);
        }
        renderer.setFont(this.table.getFont());
        int rowMargin = this.table.getRowMargin();
        return renderer.getBaseline(Integer.MAX_VALUE, this.table.getRowHeight() - rowMargin) + rowMargin / 2;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    protected Dimension createTableSize(long width) {
        long tmp;
        int height = 0;
        int rowCount = this.table.getRowCount();
        if (rowCount > 0 && this.table.getColumnCount() > 0) {
            Rectangle r = this.table.getCellRect(rowCount - 1, 0, true);
            height = r.y + r.height;
        }
        if ((tmp = Math.abs(width)) > Integer.MAX_VALUE) {
            tmp = Integer.MAX_VALUE;
        }
        return new Dimension((int)tmp, height);
    }

    protected abstract void paintDropLines(Graphics var1);

    protected Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    protected Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    protected Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (ltr) {
                rect.x += rect.width;
            }
        } else if (!ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    protected abstract void paintGrid(Graphics var1, int var2, int var3, int var4, int var5);

    protected abstract void paintCells(Graphics var1, int var2, int var3, int var4, int var5);

    protected abstract void paintCell(Graphics var1, Rectangle var2, int var3, int var4);

    protected abstract int viewIndexForColumn(TableColumn var1);

    protected class Handler
    implements FocusListener,
    MouseInputListener,
    PropertyChangeListener,
    ListSelectionListener,
    ActionListener,
    DragRecognitionSupport.BeforeDrag,
    KeyListener {
        protected final FocusListener focusListener;
        protected final KeyListener keyListener;
        protected Component dispatchComponent;
        protected int pressedRow;
        protected int pressedCol;
        protected MouseEvent pressedEvent;
        protected boolean dragPressDidSelection;
        protected boolean dragStarted;
        protected boolean shouldStartTimer;
        protected boolean outsidePrefSize;
        protected Timer timer = null;

        protected Handler(KeyListener keyListener, FocusListener focusListener) {
            this.keyListener = keyListener;
            this.focusListener = focusListener;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.focusListener != null) {
                this.focusListener.focusGained(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.focusListener != null) {
                this.focusListener.focusLost(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.keyListener != null) {
                this.keyListener.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.keyListener != null) {
                this.keyListener.keyReleased(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.keyListener != null) {
                this.keyListener.keyTyped(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtil.shouldIgnore(e, TableUIBridge.this.table)) {
                return;
            }
            if (TableUIBridge.this.table.isEditing() && !TableUIBridge.this.table.getCellEditor().stopCellEditing()) {
                Component editorComponent = TableUIBridge.this.table.getEditorComponent();
                if (editorComponent != null && !editorComponent.hasFocus()) {
                    SwingUtil.compositeRequestFocus(editorComponent);
                }
                return;
            }
            Point p = e.getPoint();
            this.pressedRow = TableUIBridge.this.table.rowAtPoint(p);
            this.pressedCol = TableUIBridge.this.table.columnAtPoint(p);
            this.outsidePrefSize = TableUIBridge.this.pointOutsidePrefSize(this.pressedRow, this.pressedCol, p);
            if (TableUIBridge.this.isFileList) {
                boolean bl = this.shouldStartTimer = TableUIBridge.this.table.isCellSelected(this.pressedRow, this.pressedCol) && !e.isShiftDown() && !DarkUIUtil.isMenuShortcutKeyDown(e) && !this.outsidePrefSize;
            }
            if (TableUIBridge.this.table.getDragEnabled()) {
                this.mousePressedDND(e);
            } else {
                SwingUtil.adjustFocus(TableUIBridge.this.table);
                if (!TableUIBridge.this.isFileList) {
                    this.setValueIsAdjusting(true);
                }
                this.adjustSelection(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtil.shouldIgnore(e, TableUIBridge.this.table)) {
                return;
            }
            if (TableUIBridge.this.table.getDragEnabled()) {
                this.mouseReleasedDND(e);
            } else if (TableUIBridge.this.isFileList) {
                this.maybeStartTimer();
            }
            this.pressedEvent = null;
            this.repostEvent(e);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        protected void mouseReleasedDND(MouseEvent e) {
            MouseEvent me = DragRecognitionSupport.mouseReleased(e);
            if (me != null) {
                SwingUtil.adjustFocus(TableUIBridge.this.table);
                if (!this.dragPressDidSelection) {
                    this.adjustSelection(me);
                }
            }
            if (!this.dragStarted) {
                if (TableUIBridge.this.isFileList) {
                    this.maybeStartTimer();
                    return;
                }
                Point p = e.getPoint();
                if (this.pressedEvent != null && TableUIBridge.this.table.rowAtPoint(p) == this.pressedRow && TableUIBridge.this.table.columnAtPoint(p) == this.pressedCol && TableUIBridge.this.table.editCellAt(this.pressedRow, this.pressedCol, this.pressedEvent)) {
                    this.setDispatchComponent(this.pressedEvent);
                    this.repostEvent(this.pressedEvent);
                    TableCellEditor ce = TableUIBridge.this.table.getCellEditor();
                    if (ce != null) {
                        ce.shouldSelectCell(this.pressedEvent);
                    }
                }
            }
        }

        protected void adjustSelection(MouseEvent e) {
            if (this.outsidePrefSize) {
                if (!(e.getID() != 501 || e.isShiftDown() && TableUIBridge.this.table.getSelectionModel().getSelectionMode() != 0)) {
                    TableUIBridge.this.table.clearSelection();
                    TableCellEditor tce = TableUIBridge.this.table.getCellEditor();
                    if (tce != null) {
                        tce.stopCellEditing();
                    }
                }
                return;
            }
            if (this.pressedCol == -1 || this.pressedRow == -1) {
                return;
            }
            boolean dragEnabled = TableUIBridge.this.table.getDragEnabled();
            if (!dragEnabled && !TableUIBridge.this.isFileList && TableUIBridge.this.table.editCellAt(this.pressedRow, this.pressedCol, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            }
            TableCellEditor editor = TableUIBridge.this.table.getCellEditor();
            if (dragEnabled || editor == null || editor.shouldSelectCell(e)) {
                TableUIBridge.this.table.changeSelection(this.pressedRow, this.pressedCol, DarkUIUtil.isMenuShortcutKeyDown(e), e.isShiftDown());
            }
        }

        protected void maybeStartTimer() {
            if (!this.shouldStartTimer) {
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        protected void setDispatchComponent(MouseEvent e) {
            Component editorComponent = TableUIBridge.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(TableUIBridge.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
            SwingUtil.setSkipClickCount(this.dispatchComponent, e.getClickCount() - 1);
        }

        protected boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !TableUIBridge.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(TableUIBridge.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        protected void mousePressedDND(MouseEvent e) {
            this.pressedEvent = e;
            boolean grabFocus = true;
            this.dragStarted = false;
            if (this.canStartDrag() && DragRecognitionSupport.mousePressed(e)) {
                this.dragPressDidSelection = false;
                if (DarkUIUtil.isMenuShortcutKeyDown(e) && TableUIBridge.this.isFileList) {
                    return;
                }
                if (!e.isShiftDown() && TableUIBridge.this.table.isCellSelected(this.pressedRow, this.pressedCol)) {
                    TableUIBridge.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                    TableUIBridge.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
                    return;
                }
                this.dragPressDidSelection = true;
                grabFocus = false;
            } else if (!TableUIBridge.this.isFileList) {
                this.setValueIsAdjusting(true);
            }
            if (grabFocus) {
                SwingUtil.adjustFocus(TableUIBridge.this.table);
            }
            this.adjustSelection(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        protected boolean canStartDrag() {
            if (this.pressedRow == -1 || this.pressedCol == -1) {
                return false;
            }
            if (TableUIBridge.this.isFileList) {
                return !this.outsidePrefSize;
            }
            if (TableUIBridge.this.table.getSelectionModel().getSelectionMode() == 0 && TableUIBridge.this.table.getColumnModel().getSelectionModel().getSelectionMode() == 0) {
                return true;
            }
            return TableUIBridge.this.table.isCellSelected(this.pressedRow, this.pressedCol);
        }

        protected void setValueIsAdjusting(boolean flag) {
            TableUIBridge.this.table.getSelectionModel().setValueIsAdjusting(flag);
            TableUIBridge.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TableUIBridge.this.table.editCellAt(this.pressedRow, this.pressedCol, null);
            Component editorComponent = TableUIBridge.this.table.getEditorComponent();
            if (editorComponent != null && !editorComponent.hasFocus()) {
                SwingUtil.compositeRequestFocus(editorComponent);
            }
        }

        @Override
        public void dragStarting(MouseEvent me) {
            this.dragStarted = true;
            if (DarkUIUtil.isMenuShortcutKeyDown(me) && TableUIBridge.this.isFileList) {
                TableUIBridge.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                TableUIBridge.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
            }
            this.pressedEvent = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtil.shouldIgnore(e, TableUIBridge.this.table)) {
                return;
            }
            if (TableUIBridge.this.table.getDragEnabled() && (DragRecognitionSupport.mouseDragged(e, this) || this.dragStarted)) {
                return;
            }
            this.repostEvent(e);
            if (TableUIBridge.this.isFileList || TableUIBridge.this.table.isEditing()) {
                return;
            }
            Point p = e.getPoint();
            int row = TableUIBridge.this.table.rowAtPoint(p);
            int column = TableUIBridge.this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            TableUIBridge.this.table.changeSelection(row, column, DarkUIUtil.isMenuShortcutKeyDown(e), true);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String changeName = event.getPropertyName();
            if ("Table.isFileList".equals(changeName)) {
                TableUIBridge.this.isFileList = PropertyUtil.getBooleanProperty(TableUIBridge.this.table, "Table.isFileList");
            }
        }
    }
}

