/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.DerivableIcon;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.icons.ImageSource;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;

public class DerivableImageIcon
implements DerivableIcon<DerivableImageIcon>,
IconLoader.CacheableIcon,
ImageSource,
Accessible {
    private static final Logger LOGGER = LogUtil.getLogger(DerivableImageIcon.class);
    private static final int DEFAULT_SCALING_MODE = 1;
    private final int scalingMode;
    private int width;
    private int height;
    private final LazyValue<Image> original;
    private final LazyImageValue image;
    private String description;
    private AccessibleContext accessibleContext;
    private IconLoader.IconKey iconKey;

    public DerivableImageIcon(String imagePath) {
        this(() -> Toolkit.getDefaultToolkit().getImage(imagePath), -1, -1);
    }

    public DerivableImageIcon(String imagePath, int width, int height) {
        this(imagePath, width, height, 1);
    }

    public DerivableImageIcon(String imagePath, int width, int height, int scalingMode) {
        this(() -> Toolkit.getDefaultToolkit().getImage(imagePath), width, height, scalingMode);
    }

    public DerivableImageIcon(URL url) {
        this(url, -1, -1, 1);
    }

    public DerivableImageIcon(URL url, int width, int height) {
        this(url, width, height, 1);
    }

    public DerivableImageIcon(URL url, int width, int height, int scalingMode) {
        this(() -> Toolkit.getDefaultToolkit().getImage(url), width, height, scalingMode);
    }

    public DerivableImageIcon(Supplier<Image> imageSupplier) {
        this(imageSupplier, -1, -1, 1);
    }

    public DerivableImageIcon(Supplier<Image> imageSupplier, int width, int height) {
        this(imageSupplier, width, height, 1);
    }

    public DerivableImageIcon(Supplier<Image> imageSupplier, int width, int height, int scalingMode) {
        this.width = width;
        this.height = height;
        this.scalingMode = scalingMode;
        this.original = new LazyValue<Image>(imageSupplier);
        this.image = new LazyImageValue(this);
    }

    public DerivableImageIcon(ImageIcon icon) {
        this(icon, 1);
    }

    public DerivableImageIcon(ImageIcon icon, int scalingMode) {
        this(icon != null ? icon.getImage() : null, scalingMode);
    }

    public DerivableImageIcon(ImageIcon icon, int width, int height) {
        this(icon, width, height, 1);
    }

    public DerivableImageIcon(ImageIcon icon, int width, int height, int scalingMode) {
        this(icon != null ? icon.getImage() : null, width, height, scalingMode);
        if (icon != null) {
            this.setDescription(icon.getDescription());
        }
    }

    public DerivableImageIcon(Image img) {
        this(img, 1);
    }

    public DerivableImageIcon(Image img, int scalingMode) {
        this(img, img != null ? img.getWidth(null) : 0, img != null ? img.getHeight(null) : 0, scalingMode);
    }

    public DerivableImageIcon(Image img, int width, int height) {
        this(img, width, height, 1);
    }

    public DerivableImageIcon(Image img, int width, int height, int scalingMode) {
        this.width = width;
        this.height = height;
        this.scalingMode = scalingMode;
        this.original = new LazyValue<Image>(img);
        this.image = new LazyImageValue(this);
    }

    protected DerivableImageIcon(DerivableImageIcon parent, int width, int height) {
        this.width = width;
        this.height = height;
        this.scalingMode = parent.scalingMode;
        this.original = parent.original;
        this.description = parent.description;
        this.image = parent.image.derive(this);
    }

    @Override
    public DerivableImageIcon derive(int width, int height) {
        if (this.sameIconRequested(width, height)) {
            return this;
        }
        return new DerivableImageIcon(this, width, height);
    }

    private boolean sameIconRequested(int width, int height) {
        if (this.width == width && this.height == height) {
            return true;
        }
        if (width < 0 && height < 0) {
            if (this.width < 0 && this.height < 0) {
                return true;
            }
            if (this.original.isInitialized()) {
                Image img = this.original.get();
                return this.width == img.getWidth(null) && this.height == img.getHeight(null);
            }
        }
        return false;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Image img = this.image.get();
        if (img != null) {
            if (c == null && !this.ensureImageLoaded(img)) {
                LOGGER.warning("Image could not be loaded in time for painting.");
                return;
            }
            g.drawImage(img, x, y, this.width, this.height, c);
        }
    }

    private boolean ensureImageLoaded(Image img) {
        MediaTracker tracker = new MediaTracker(new Component(){});
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException ex) {
            return false;
        }
        return true;
    }

    public Image getImage() {
        return this.getImage(null);
    }

    public Image getImage(ImageObserver observer) {
        return this.image.get(observer);
    }

    protected Image getOriginal() {
        Image img = this.original.get();
        this.calculateSize();
        return img;
    }

    private void calculateSize() {
        Image originalImage = this.original.get();
        if (originalImage != null && (this.width < 0 || this.height < 0)) {
            if (this.width < 0) {
                this.width = originalImage.getWidth(null);
            }
            if (this.height < 0) {
                this.height = originalImage.getHeight(null);
            }
            if (this.iconKey != null) {
                if (this.width >= 0) {
                    this.iconKey.w = this.width;
                }
                if (this.height >= 0) {
                    this.iconKey.h = this.height;
                }
            }
        }
    }

    @Override
    public int getIconWidth() {
        if (this.width < 0) {
            this.calculateSize();
        }
        return this.width;
    }

    @Override
    public int getIconHeight() {
        if (this.height < 0) {
            this.calculateSize();
        }
        return this.height;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDerivableImageIcon(this);
        }
        return this.accessibleContext;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Image createImage(Dimension size) {
        return this.getOriginal().getScaledInstance(size.width, size.height, this.scalingMode);
    }

    @Override
    public void setCacheKey(IconLoader.IconKey key) {
        this.iconKey = key;
        if (this.iconKey != null && this.width >= 0 && this.height >= 0) {
            this.iconKey.w = this.width;
            this.iconKey.h = this.height;
        }
    }

    IconLoader.IconKey getCacheKey() {
        return this.iconKey;
    }

    protected static class LazyImageValue
    extends LazyValue<Image> {
        private final DerivableImageIcon icon;

        public LazyImageValue(DerivableImageIcon icon) {
            super((Image)null);
            this.icon = icon;
        }

        public LazyImageValue derive(DerivableImageIcon icon) {
            if (this.icon.width == icon.width && this.icon.height == icon.height) {
                return this;
            }
            return new LazyImageValue(icon);
        }

        public Image get(ImageObserver observer) {
            if (this.value == null) {
                this.set(this.load(observer));
            }
            return (Image)this.value;
        }

        @Override
        public Image get() {
            return this.get(null);
        }

        protected Image load(ImageObserver observer) {
            Image originalImage = this.icon.getOriginal();
            int width = this.icon.getIconWidth();
            int height = this.icon.getIconHeight();
            if (originalImage != null && width > 0 && height > 0) {
                if (originalImage.getWidth(observer) != width || originalImage.getHeight(observer) != height) {
                    return originalImage.getScaledInstance(width, height, this.icon.scalingMode);
                }
                return originalImage;
            }
            return null;
        }
    }

    protected static class AccessibleDerivableImageIcon
    extends AccessibleContext
    implements AccessibleIcon {
        private final DerivableImageIcon icon;

        public AccessibleDerivableImageIcon(DerivableImageIcon icon) {
            this.icon = icon;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        @Override
        public String getAccessibleIconDescription() {
            return this.icon.getDescription();
        }

        @Override
        public void setAccessibleIconDescription(String description) {
            this.icon.setDescription(description);
        }

        @Override
        public int getAccessibleIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getAccessibleIconHeight() {
            return this.icon.getIconHeight();
        }
    }
}

