/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.listener;

import com.github.weisj.darklaf.components.DynamicUI;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class UIUpdater
implements Consumer<JComponent> {
    private static final String KEY_UPDATER = "JComponent.uiUpdaterLister";

    public static void registerComponent(JComponent component) {
        if (component == null) {
            return;
        }
        UIUpdater.removeComponent(component);
        UIUpdater updater = new UIUpdater();
        component.putClientProperty(KEY_UPDATER, updater);
        DynamicUI.registerCallback(component, updater, false);
    }

    public static void removeComponent(JComponent component) {
        if (component == null) {
            return;
        }
        Object updater = component.getClientProperty(KEY_UPDATER);
        if (updater instanceof UIUpdater) {
            UIUpdater.removeComponent(component, (UIUpdater)updater);
        }
    }

    private static void removeComponent(JComponent component, UIUpdater updater) {
        component.putClientProperty(KEY_UPDATER, null);
        DynamicUI.removeCallback(component, updater);
    }

    private UIUpdater() {
    }

    @Override
    public void accept(JComponent c) {
        SwingUtilities.updateComponentTreeUI(c);
    }
}

