/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.api;

import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPlugin;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPluginMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class RfbClassTransformerHandle {
    @NotNull
    private final String id;
    @NotNull
    private final String[] additionalIds;
    @NotNull
    private final RfbPluginMetadata pluginMetadata;
    @NotNull
    private final RfbPlugin plugin;
    @NotNull
    private final RfbClassTransformer transformer;
    @NotNull
    private final @NotNull List<@NotNull String> exclusions;

    public RfbClassTransformerHandle(@NotNull RfbPluginMetadata pluginMetadata, @NotNull RfbPlugin plugin, @NotNull RfbClassTransformer transformer) {
        String[] xformerExclusions;
        this.pluginMetadata = pluginMetadata;
        this.plugin = plugin;
        this.transformer = transformer;
        String xId = transformer.id();
        if (!RfbPluginMetadata.ID_VALIDATOR.matcher(xId).matches()) {
            throw new RuntimeException("Illegal transfomer ID " + xId + " in RFB plugin " + pluginMetadata.id());
        }
        this.id = this.pluginMetadata().id() + ":" + transformer.id();
        RfbPluginMetadata.IdAndVersion[] additionalPluginIds = pluginMetadata.additionalVersions();
        this.additionalIds = new String[additionalPluginIds.length];
        for (int i = 0; i < additionalPluginIds.length; ++i) {
            this.additionalIds[i] = additionalPluginIds[i].id() + ":" + transformer.id();
        }
        TreeSet<String> allExclusions = new TreeSet<String>();
        allExclusions.add(plugin.getClass().getPackage().getName() + ".");
        allExclusions.add(transformer.getClass().getPackage().getName() + ".");
        String[] pluginExclusions = pluginMetadata.transformerExclusions();
        if (pluginExclusions != null) {
            allExclusions.addAll(Arrays.asList(pluginExclusions));
        }
        if ((xformerExclusions = transformer.additionalExclusions()) != null) {
            allExclusions.addAll(Arrays.asList(xformerExclusions));
        }
        ArrayList<@NotNull String> exclusions = new ArrayList<String>(allExclusions.size());
        String previousExclusion = null;
        for (String exclusion : allExclusions) {
            if (previousExclusion != null && exclusion.startsWith(previousExclusion)) continue;
            previousExclusion = exclusion;
            exclusions.add(exclusion);
        }
        exclusions.trimToSize();
        this.exclusions = exclusions;
    }

    @NotNull
    public String id() {
        return this.id;
    }

    @NotNull
    public @NotNull String @NotNull [] additionalIds() {
        return this.additionalIds;
    }

    @NotNull
    public RfbPluginMetadata pluginMetadata() {
        return this.pluginMetadata;
    }

    @NotNull
    public RfbPlugin plugin() {
        return this.plugin;
    }

    @NotNull
    public RfbClassTransformer transformer() {
        return this.transformer;
    }

    @NotNull
    public @NotNull List<@NotNull String> exclusions() {
        return this.exclusions;
    }
}

