/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory;

import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static Configuration configuration;
    private final File file;
    public static boolean requireGlasses;
    public static boolean colorEnable;
    public static int colorAlpha;
    public static int colorR;
    public static int colorG;
    public static int colorB;
    public static int syncFreq;
    public static boolean renderText;
    public static boolean renderSuffixDarkened;
    public static boolean renderThirdPerson;
    public static boolean renderMultiple;
    public static boolean enableStacking;
    public static boolean renderName;
    public static boolean hideItemsNotSelected;
    public static int mode;
    public static int cycle;
    public static int keyMode;
    public static boolean enableEntities;
    public static boolean keyState;
    public static boolean rotateItems;
    public static boolean debug;
    public static double renderScaling;
    public static final ArrayList<String> bannedTiles;
    public static final ArrayList<String> bannedEntities;
    public static final HashMap<String, String> nameOverrides;

    public Config(File file) {
        this.file = file;
        this.reload();
    }

    public void overrideBannedThings() {
        configuration.get("holoinventory", "bannedTiles", bannedTiles.toArray(new String[0]), "Banned inventories.\nUse the ingame command '/holoinventory' to change this list easily.").set(bannedTiles.toArray(new String[0]));
        configuration.get("holoinventory", "bannedEntities", bannedEntities.toArray(new String[0]), "Banned inventories.\nUse the ingame command '/holoinventory' to change this list easily.").set(bannedEntities.toArray(new String[0]));
        this.save();
    }

    public void reload() {
        configuration = new Configuration(this.file);
        this.doConfig();
    }

    public void overrideNameThings() {
        int i = 0;
        String[] things = new String[nameOverrides.size()];
        for (Map.Entry<String, String> entry : nameOverrides.entrySet()) {
            things[i] = '\"' + entry.getKey() + '#' + entry.getValue() + '\"';
            ++i;
        }
        configuration.get("holoinventory", "overrideNameThings", things, "Name overrides.\nUse the ingame command '/holoinventory' to change this list easily.").set(things);
        this.save();
    }

    public void doConfig() {
        String[] things;
        configuration.addCustomCategoryComment("holoinventory", "All our settings are in here, as you might expect...");
        renderScaling = configuration.get("holoinventory", "renderScaling", renderScaling, "Visual scale factor (0.0-1.0)").getDouble(1.0);
        requireGlasses = configuration.get("holoinventory", "requireGlasses", requireGlasses, "Makes HoloInventory require HoloGlasses").getBoolean(true);
        colorEnable = configuration.get("holoinventory", "colorEnable", colorEnable, "Enable a BG color").getBoolean(false);
        colorAlpha = configuration.get("holoinventory", "colorAlpha", colorAlpha, "The BG transparancy (0-255)").getInt();
        colorR = configuration.get("holoinventory", "colorRed", colorR, "0-255").getInt();
        colorG = configuration.get("holoinventory", "colorGreen", colorG, "0-255").getInt();
        colorB = configuration.get("holoinventory", "colorBlue", colorB, "0-255").getInt();
        keyMode = configuration.get("holoinventory", "keyMode", keyMode, "Valid modes:\n0: Always display hologram.\n1: The key toggles the rendering.\n2: Only render hologram while key pressed.\n3: Don't render hologram while key pressed.").getInt();
        keyState = configuration.get("holoinventory", "keyState", keyState, "Stores last toggle value. Don't worry about this.").getBoolean(keyState);
        renderName = configuration.get("holoinventory", "renderName", renderName, "Renders the inv name above the hologram").getBoolean(true);
        renderText = configuration.get("holoinventory", "renderText", renderText, "Render the stacksize as text on top of the items").getBoolean(true);
        renderSuffixDarkened = configuration.get("holoinventory", "renderSuffixDarkened", renderSuffixDarkened, "Render the stacksize suffix darkened").getBoolean(true);
        renderThirdPerson = configuration.get("holoinventory", "renderThirdPerson", renderThirdPerson, "Render in third person mode").getBoolean(false);
        renderMultiple = configuration.get("holoinventory", "renderMultiple", renderMultiple, "Render multiple items depending on stacksize").getBoolean(true);
        enableEntities = configuration.get("holoinventory", "enableEntities", enableEntities, "Set to false to prevent all entities from rendering the hologram.").getBoolean(true);
        hideItemsNotSelected = configuration.get("holoinventory", "filterItemsByNEI", hideItemsNotSelected, "Filter items to render by the NEI search string (when focused)").getBoolean(true);
        syncFreq = configuration.get("holoinventory", "syncFreq", syncFreq, "Amout of seconds pass before sending a new update to the client looking at the chest.").getInt();
        enableStacking = configuration.get("holoinventory", "enableStacking", enableStacking, "Stack items, even above 64.").getBoolean(enableStacking);
        mode = configuration.get("holoinventory", "mode", mode, "Valid modes:\n0: Default mode (Display all items).\n1: Sorting mode, biggest stack size first.\n2: Most abundant mode (Only display the item the most abundant in the chest.\n3: Same as 1, but with 3 items.\n4: Same as 1, but with 5 items.\n5: Same as 1, but with 7 items.\n6: Same as 1, but with 9 items.").getInt();
        cycle = configuration.get("holoinventory", "cycle", cycle, "Cycle trough all the items one by one. Set to the delay time wanted in ticks. If 0, cycle mode is off. Still takes into a count the mode.").getInt();
        rotateItems = configuration.get("holoinventory", "rotateItems", rotateItems, "Rotate the items in the hologram. Only works on fancy rendering.").getBoolean(rotateItems);
        bannedTiles.clear();
        bannedTiles.addAll(Arrays.asList(configuration.get("holoinventory", "bannedTiles", bannedTiles.toArray(new String[0]), "Banned inventories.\nUse the ingame command '/holoinventory' to change this list easily.").getStringList()));
        bannedEntities.clear();
        bannedEntities.addAll(Arrays.asList(configuration.get("holoinventory", "bannedEntities", bannedEntities.toArray(new String[0]), "Banned inventories.\nUse the ingame command '/holoinventory' to change this list easily.").getStringList()));
        nameOverrides.clear();
        for (String thing : things = configuration.get("holoinventory", "overrideNameThings", new String[0], "Name overrides.\nUse the ingame command '/holoinventory' to change this list easily.").getStringList()) {
            String[] subThings = (thing = thing.substring(1, thing.length() - 1)).split("#", 2);
            if (subThings.length != 2) continue;
            nameOverrides.put(subThings[0], subThings[1]);
        }
        debug = configuration.getBoolean("debug", "holoinventory", debug, "Enable debug, use when errors or weird behaviour happens.");
        this.save();
    }

    public void save() {
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public void setKeyState(boolean keyState) {
        configuration.get("holoinventory", "keyState", keyState, "Stores last toggle value. Don't worry about this.").set(keyState);
        this.save();
    }

    static {
        requireGlasses = Loader.isModLoaded((String)"dreamcraft");
        colorEnable = false;
        colorAlpha = 200;
        colorR = 14;
        colorG = 157;
        colorB = 196;
        syncFreq = 2;
        renderText = true;
        renderSuffixDarkened = true;
        renderThirdPerson = false;
        renderMultiple = true;
        enableStacking = true;
        renderName = true;
        hideItemsNotSelected = true;
        mode = 0;
        cycle = 0;
        keyMode = 1;
        enableEntities = true;
        keyState = true;
        rotateItems = true;
        debug = false;
        renderScaling = 1.0;
        bannedTiles = new ArrayList();
        bannedEntities = new ArrayList();
        nameOverrides = new HashMap();
    }
}

