/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.network.PacketUpdate;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTileUpdate
extends PacketUpdate {
    public int posX;
    public int posY;
    public int posZ;

    public PacketTileUpdate() {
        super(0);
    }

    public PacketTileUpdate(ISerializable tile) {
        this(0, tile);
    }

    public PacketTileUpdate(int packetId, ISerializable tile) {
        super(packetId, tile);
        TileEntity entity = (TileEntity)tile;
        this.posX = entity.field_145851_c;
        this.posY = entity.field_145848_d;
        this.posZ = entity.field_145849_e;
    }

    @Override
    public void writeIdentificationData(ByteBuf data) {
        data.writeInt(this.posX);
        data.writeShort(this.posY);
        data.writeInt(this.posZ);
    }

    @Override
    public void readIdentificationData(ByteBuf data) {
        this.posX = data.readInt();
        this.posY = data.readShort();
        this.posZ = data.readInt();
    }

    public boolean targetExists(World world) {
        return world.func_72899_e(this.posX, this.posY, this.posZ);
    }

    public TileEntity getTarget(World world) {
        return world.func_147438_o(this.posX, this.posY, this.posZ);
    }
}

