/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.concurrent.cas;

import com.gtnewhorizon.gtnhlib.concurrent.cas.CasAdapter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CasMap<K, V>
extends CasAdapter<Map<K, V>, Object2ObjectOpenHashMap<K, V>>
implements Map<K, V> {
    public CasMap() {
        super(Collections.unmodifiableMap(new Object2ObjectOpenHashMap()));
    }

    public CasMap(@Nullable Object2ObjectOpenHashMap<K, V> map) {
        super(Collections.unmodifiableMap(map == null ? new Object2ObjectOpenHashMap() : new Object2ObjectOpenHashMap<K, V>(map)));
    }

    public CasMap(K @NotNull [] keys, V @NotNull [] values) {
        super(Collections.unmodifiableMap(new Object2ObjectOpenHashMap<K, V>(keys, values)));
    }

    public CasMap(@NotNull @NotNull Consumer<@NotNull Object2ObjectOpenHashMap<K, V>> constructor) {
        this();
        Object2ObjectOpenHashMap elems = new Object2ObjectOpenHashMap();
        constructor.accept(elems);
        this.overwrite(this.immutableCopyOf(elems));
    }

    @Override
    @NotNull
    public final Object2ObjectOpenHashMap<K, V> mutableCopyOf(@NotNull Map<K, V> data) {
        return new Object2ObjectOpenHashMap<K, V>(data);
    }

    @Override
    @NotNull
    public final Map<K, V> immutableCopyOf(@NotNull Object2ObjectOpenHashMap<K, V> data) {
        return Collections.unmodifiableMap(new Object2ObjectOpenHashMap<K, V>(data));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return ((Map)this.read()).getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.mutate(m -> {
            m.forEach(action);
            return null;
        });
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.mutate(m -> {
            m.replaceAll(function);
            return null;
        });
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        Object oldValue = ((Map)this.read()).get(key);
        if (oldValue != null) {
            return oldValue;
        }
        return (V)this.mutate(m -> m.putIfAbsent(key, value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object presentValue = ((Map)this.read()).get(key);
        if (!Objects.equals(value, presentValue)) {
            return false;
        }
        return this.mutate(m -> m.remove(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object presentValue = ((Map)this.read()).get(key);
        if (!Objects.equals(oldValue, presentValue)) {
            return false;
        }
        return this.mutate(m -> m.replace(key, oldValue, newValue));
    }

    @Override
    @Nullable
    public V replace(K key, V value) {
        return (V)this.mutate(m -> m.replace(key, value));
    }

    @Override
    public V computeIfAbsent(K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
        Object oldValue = ((Map)this.read()).get(key);
        if (oldValue != null) {
            return oldValue;
        }
        return (V)this.mutate(m -> m.computeIfAbsent(key, mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue = ((Map)this.read()).get(key);
        if (oldValue == null) {
            return null;
        }
        return (V)this.mutate(m -> m.computeIfPresent(key, remappingFunction));
    }

    @Override
    public V compute(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.mutate(m -> m.compute(key, remappingFunction));
    }

    @Override
    public V merge(K key, @NotNull V value, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.mutate(m -> m.merge(key, value, remappingFunction));
    }

    @Override
    public int size() {
        return ((Map)this.read()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.read()).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((Map)this.read()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((Map)this.read()).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return ((Map)this.read()).get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        return (V)this.mutate(m -> m.put(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)this.mutate(m -> m.remove(key));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> other) {
        this.mutate(m -> {
            m.putAll(other);
            return null;
        });
    }

    @Override
    public void clear() {
        this.mutate(m -> {
            m.clear();
            return null;
        });
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return ((Map)this.read()).keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return ((Map)this.read()).values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return ((Map)this.read()).entrySet();
    }

    @Override
    public int hashCode() {
        return ((Map)this.read()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map myMap = (Map)this.read();
        Map otherMap = obj instanceof CasMap ? (Map)((CasMap)obj).read() : (Map)obj;
        return myMap.equals(otherMap);
    }

    public String toString() {
        return ((Map)this.read()).toString();
    }
}

