/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.core.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import remoteio.common.block.BlockSkylight;
import remoteio.common.lib.ModBlocks;

public class BlockUpdateTicker {
    public static final int MAX_PER_TICK = 10;
    private static Set<BlockUpdate> blockUpdateSet = Sets.newConcurrentHashSet();

    public static void registerBlockUpdate(World world, int x, int y, int z, Block block, int meta) {
        blockUpdateSet.add(new BlockUpdate(x, y, z, world.field_73011_w.field_76574_g, block, meta));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        ArrayList removalList = Lists.newArrayList();
        int updateCount = 0;
        for (BlockUpdate blockUpdate : blockUpdateSet) {
            if (updateCount >= 10) break;
            if (event.world.field_73011_w.field_76574_g != blockUpdate.dimension) continue;
            blockUpdate.apply(event.world);
            removalList.add(blockUpdate);
            ++updateCount;
        }
        for (int i = 0; i < removalList.size(); ++i) {
            blockUpdateSet.remove(removalList.get(i));
        }
    }

    public static final class BlockUpdate {
        public final int x;
        public final int y;
        public final int z;
        public final int dimension;
        public final Block block;
        public final int meta;

        public BlockUpdate(int x, int y, int z, int dimension, Block block, int meta) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dimension = dimension;
            this.block = block;
            this.meta = meta;
        }

        public void apply(World world) {
            if (world.func_147439_a(this.x, this.y, this.z) == this.block) {
                world.func_72921_c(this.x, this.y, this.z, this.meta, 3);
            } else {
                world.func_147465_d(this.x, this.y, this.z, this.block, this.meta, 3);
            }
            world.func_147463_c(EnumSkyBlock.Block, this.x, this.y, this.z);
            world.func_147463_c(EnumSkyBlock.Sky, this.x, this.y, this.z);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Block block = world.func_147439_a(this.x + side.offsetX, this.y + side.offsetY, this.z + side.offsetZ);
                if (block == null || block != ModBlocks.skylight) continue;
                ((BlockSkylight)block).onBlockUpdate(world, this.x + side.offsetX, this.y + side.offsetY, this.z + side.offsetZ, ModBlocks.skylight, this.meta);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockUpdate that = (BlockUpdate)o;
            if (this.dimension != that.dimension) {
                return false;
            }
            if (this.x != that.x) {
                return false;
            }
            if (this.y != that.y) {
                return false;
            }
            return this.z == that.z;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            result = 31 * result + this.dimension;
            return result;
        }
    }
}

