/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.PipeManagerContentPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.order.DistanceTracker;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.routing.order.LogisticsOrderLinkedList;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public abstract class LogisticsOrderManager<T extends LogisticsOrder, I>
implements Iterable<T> {
    protected final LogisticsOrderLinkedList<T, I> _orders;
    protected IChangeListener listener = null;
    protected PlayerCollectionList watchingPlayers = new PlayerCollectionList();
    private final ILPPositionProvider pos;

    public LogisticsOrderManager(LogisticsOrderLinkedList<T, I> orders, ILPPositionProvider pos) {
        this._orders = orders;
        this.pos = pos;
    }

    public LogisticsOrderManager(IChangeListener listener, ILPPositionProvider pos, LogisticsOrderLinkedList<T, I> orders) {
        this(orders, pos);
        this.listener = listener;
    }

    protected void listen() {
        this.changed();
        if (this.listener != null) {
            this.listener.listenedChanged();
        }
    }

    public void dump() {
        StringBuilder sb = new StringBuilder(" ############################################# ").append(System.getProperty("line.separator"));
        for (LogisticsOrder s : this._orders) {
            sb.append(s.getAsDisplayItem()).append(" / ").append(s.getAmount()).append(" / ").append(s.getType().name()).append(System.getProperty("line.separator"));
        }
        System.out.print(sb.append(" ############################################# "));
        System.out.println();
    }

    public LinkedList<ItemIdentifierStack> getContentList(World world) {
        if (MainProxy.isClient(world) || this._orders.size() == 0) {
            return new LinkedList<ItemIdentifierStack>();
        }
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        for (LogisticsOrder request : this._orders) {
            LogisticsOrderManager.addToList(request.getAsDisplayItem(), list);
        }
        return list;
    }

    private static void addToList(ItemIdentifierStack stack, LinkedList<ItemIdentifierStack> list) {
        for (ItemIdentifierStack ident : list) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.setStackSize(ident.getStackSize() + stack.getStackSize());
            return;
        }
        list.addLast(stack.clone());
    }

    public boolean hasOrders(IOrderInfoProvider.ResourceType ... type) {
        return this.peekAtTopRequest(type) != null;
    }

    public T peekAtTopRequest(IOrderInfoProvider.ResourceType ... type) {
        List<IOrderInfoProvider.ResourceType> typeList = Arrays.asList(type);
        if (this._orders.size() == 0) {
            return null;
        }
        LogisticsOrder top = ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
        int loopCount = 0;
        while (!typeList.contains((Object)top.getType())) {
            if (++loopCount > this._orders.size()) {
                return null;
            }
            this.deferSend();
            top = this._orders.getFirst();
        }
        return (T)top;
    }

    public void sendSuccessfull(int number, boolean defersend, IRoutedItem item) {
        ((LogisticsOrder)this._orders.getFirst()).reduceAmountBy(number);
        if (((LogisticsOrder)this._orders.getFirst()).isWatched() && item != null) {
            DistanceTracker tracker = new DistanceTracker();
            item.setDistanceTracker(tracker);
            ((LogisticsOrder)this._orders.getFirst()).addDistanceTracker(tracker);
        }
        int destination = ((LogisticsOrder)this._orders.getFirst()).getRouterId();
        if (((LogisticsOrder)this._orders.getFirst()).getAmount() <= 0) {
            T order = this._orders.removeFirst();
            ((LogisticsOrder)order).setFinished(true);
            ((LogisticsOrder)order).setInProgress(false);
        }
        if (!this._orders.isEmpty()) {
            T start = this._orders.getFirst();
            if (defersend && destination == ((LogisticsOrder)start).getRouterId()) {
                this._orders.addLast(((LogisticsOrder)this._orders.removeFirst()).setInProgress(false));
                while (start != this._orders.getFirst() && destination == ((LogisticsOrder)this._orders.getFirst()).getRouterId()) {
                    this._orders.addLast(this._orders.removeFirst());
                }
                if (start == this._orders.getFirst()) {
                    this._orders.addLast(this._orders.removeFirst());
                }
                ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
            }
        }
        this.listen();
    }

    public void sendFailed() {
        if (!this._orders.isEmpty()) {
            T order = this._orders.removeFirst();
            ((LogisticsOrder)order).setFinished(true);
            ((LogisticsOrder)order).setInProgress(false);
        }
        if (!this._orders.isEmpty()) {
            ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
        }
        this.listen();
    }

    public void deferSend() {
        this._orders.addLast(((LogisticsOrder)this._orders.removeFirst()).setInProgress(false));
        ((LogisticsOrder)this._orders.getFirst()).setInProgress(true);
        this.listen();
    }

    public int totalAmountCountInAllOrders() {
        int amount = 0;
        for (LogisticsOrder request : this._orders) {
            amount += request.getAmount();
        }
        return amount;
    }

    public void setMachineProgress(byte progress) {
        if (this._orders.isEmpty()) {
            return;
        }
        ((LogisticsOrder)this._orders.getFirst()).setMachineProgress(progress);
        this.changed();
    }

    public boolean isFirstOrderWatched() {
        if (this._orders.isEmpty()) {
            return false;
        }
        return ((LogisticsOrder)this._orders.getFirst()).isWatched();
    }

    public void startWatching(EntityPlayer player) {
        this.watchingPlayers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(PipeManagerContentPacket.class).setManager(this).setLPPos(this.pos.getLPPosition()), player);
    }

    public void stopWatching(EntityPlayer player) {
        this.watchingPlayers.remove(player);
    }

    public boolean hasExtras() {
        return this._orders.hasExtras();
    }

    private void changed() {
        if (this.watchingPlayers.isEmpty()) {
            return;
        }
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(PipeManagerContentPacket.class).setManager(this).setLPPos(this.pos.getLPPosition()), this.watchingPlayers);
    }

    @Override
    public Iterator<T> iterator() {
        return this._orders.iterator();
    }
}

