/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public final class MiscUtils {
    private static final int[] R_NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] R_CHARS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    private MiscUtils() {
    }

    public static String toRomanNumeral(int number) {
        if (number < 0 || number > 3999) {
            return String.valueOf(number);
        }
        String roman = "";
        for (int i = 0; i < R_NUMBERS.length; ++i) {
            while (number >= R_NUMBERS[i]) {
                roman = roman + R_CHARS[i];
                number -= R_NUMBERS[i];
            }
        }
        return roman;
    }

    public static Vector3 interpolateEntityPosition(Entity entity, float partialTicks) {
        double iPx = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double iPy = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
        double iPz = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        return new Vector3(iPx, iPy, iPz);
    }

    public static int ticksForDays(int days) {
        return MiscUtils.ticksForHours(days * 24);
    }

    public static int ticksForHours(int hours) {
        return MiscUtils.ticksForMinutes(hours * 60);
    }

    public static int ticksForMinutes(int minutes) {
        return MiscUtils.ticksForSeconds(minutes * 60);
    }

    public static int ticksForSeconds(int seconds) {
        return seconds * 20;
    }

    public static List<ChunkCoordinates> getCoordinatesAround(ChunkCoordinates center) {
        ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
        coords.add(new ChunkCoordinates(center.field_71574_a, center.field_71572_b, center.field_71573_c));
        coords.add(new ChunkCoordinates(center.field_71574_a + 1, center.field_71572_b, center.field_71573_c));
        coords.add(new ChunkCoordinates(center.field_71574_a, center.field_71572_b, center.field_71573_c + 1));
        coords.add(new ChunkCoordinates(center.field_71574_a - 1, center.field_71572_b, center.field_71573_c));
        coords.add(new ChunkCoordinates(center.field_71574_a, center.field_71572_b, center.field_71573_c - 1));
        coords.add(new ChunkCoordinates(center.field_71574_a, center.field_71572_b - 1, center.field_71573_c));
        coords.add(new ChunkCoordinates(center.field_71574_a, center.field_71572_b + 1, center.field_71573_c));
        return coords;
    }

    public static NetworkRegistry.TargetPoint getTargetPoint(World world, Entity entity, double range) {
        return MiscUtils.getTargetPoint(world, range, MiscUtils.getPositionVector(entity));
    }

    public static NetworkRegistry.TargetPoint getTargetPoint(World world, TileEntity tileEntity, double range) {
        return MiscUtils.getTargetPoint(world, range, new Vector3(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e));
    }

    public static NetworkRegistry.TargetPoint getTargetPoint(World world, double range, Vector3 target) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, target.getX(), target.getY(), target.getZ(), range);
    }

    public static boolean isANotApprovedOrMisunderstoodPersonFromMoreDoor(EntityPlayer player) {
        return MiscUtils.isNotApproved(player) || MiscUtils.isMisunderstood(player);
    }

    public static boolean isNotApproved(EntityPlayer player) {
        int uuHash = player.func_110124_au().hashCode();
        return uuHash == 914342508;
    }

    public static boolean isMisunderstood(EntityPlayer player) {
        int uuHash = player.func_110124_au().hashCode();
        return uuHash == 1529485240;
    }

    public static boolean isPrivilegedUser(EntityPlayer player) {
        if (MiscUtils.isANotApprovedOrMisunderstoodPersonFromMoreDoor(player)) {
            return true;
        }
        int uuHashOther = player.func_110124_au().hashCode();
        switch (uuHashOther) {
            case -1899266570: 
            case -335313669: 
            case 126020810: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerFakeMP(EntityPlayerMP player) {
        if (player instanceof FakePlayer) {
            return true;
        }
        if (player.getClass() != EntityPlayerMP.class) {
            return true;
        }
        if (player.field_71135_a == null) {
            return true;
        }
        try {
            player.func_71114_r().length();
            player.field_71135_a.field_147371_a.func_74430_c().toString();
        }
        catch (Exception exc) {
            return true;
        }
        if (MinecraftServer.func_71276_C().func_71203_ab().field_72404_b == null) {
            return true;
        }
        return !MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.contains(player);
    }

    public static Vector3 getPositionVector(Entity e) {
        Vector3 v = new Vector3(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        if (e instanceof EntityItem) {
            v.setY(v.getY() + (double)0.2f);
        }
        return v;
    }
}

