/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.SlotAdventure;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.util.Utils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidTank;

public class SlotFluid
extends SlotAdventure {
    SlotFluid(IInventory inventory, int slotIndex, int posX, int posY) {
        super(inventory, slotIndex, posX, posY);
    }

    static boolean isContainer(ItemStack stack) {
        return FluidContainerRegistry.isContainer((ItemStack)stack);
    }

    static boolean isEmpty(ItemStack stack) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    static boolean isEmpty(FluidTank tank) {
        return tank.getFluidAmount() == 0;
    }

    static boolean isFilled(ItemStack stack) {
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    static boolean isEqualFluid(ItemStack container, FluidTank tank) {
        return SlotFluid.getFluidID(container) == SlotFluid.getFluidID(tank);
    }

    static int getFluidID(ItemStack stack) {
        if (stack == null || SlotFluid.isEmpty(stack)) {
            return -1;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack).getFluid().getID();
    }

    static int getFluidID(FluidTank tank) {
        if (tank == null || tank.getFluidAmount() <= 0) {
            return -1;
        }
        return tank.getFluid().getFluid().getID();
    }

    static Fluid getFluid(ItemStack stack) {
        if (stack == null || SlotFluid.isEmpty(stack)) {
            return null;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack).getFluid();
    }

    static int getCapacity(ItemStack stack) {
        return FluidContainerRegistry.getContainerCapacity((ItemStack)stack);
    }

    static boolean canFitToTank(ItemStack container, FluidTank tank) {
        return tank.getFluidAmount() + SlotFluid.getCapacity(container) <= tank.getCapacity();
    }

    static boolean isEqualAndCanFit(ItemStack container, FluidTank tank) {
        return SlotFluid.isEqualFluid(container, tank) && SlotFluid.canFitToTank(container, tank);
    }

    static ItemStack getEmptyContainer(ItemStack container) {
        return FluidContainerRegistry.drainFluidContainer((ItemStack)container);
    }

    public boolean func_75214_a(ItemStack stack) {
        return stack != null && (SlotFluid.isContainer(stack) || stack.func_77973_b() instanceof ItemHose);
    }

    public void func_75218_e() {
        if (Utils.inServer() && this.field_75224_c instanceof IInventoryTanks) {
            ((IInventoryTanks)this.field_75224_c).updateTankSlots();
        }
        super.func_75218_e();
    }

    public int func_75219_a() {
        return 4;
    }
}

