/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.items;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemFocusPouch;
import thaumcraft.common.items.wands.ItemWandCasting;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.items.InventoryForItem;
import tuhljin.automagy.items.ModItemFocus;
import tuhljin.automagy.lib.AutomagyConfig;
import tuhljin.automagy.lib.ThaumcraftExtension;

public class ItemFocusCrafting
extends ModItemFocus {
    public static AspectList visCost = new AspectList().add(Aspect.ORDER, 7);
    public static AspectList visCostEmpty = new AspectList();
    protected IIcon iconDepth;
    protected IIcon iconOrnament;
    public static FocusUpgradeType gratis = ThaumcraftExtension.createFocusUpgrade(AutomagyConfig.focusUpgradeGratis, "gratis", new AspectList().add(Aspect.HUNGER, 1).add(Aspect.MAGIC, 1));
    public static FocusUpgradeType transposing = ThaumcraftExtension.createFocusUpgrade(AutomagyConfig.focusUpgradeTransposing, "transposing", new AspectList().add(Aspect.EXCHANGE, 1).add(Aspect.TOOL, 1));
    public static FocusUpgradeType storage = ThaumcraftExtension.createFocusUpgrade(AutomagyConfig.focusUpgradeStorage, "storage", new AspectList().add(Aspect.ELDRITCH, 1));

    public ItemFocusCrafting(String name) {
        super(name);
    }

    @Override
    public void func_94581_a(IIconRegister ir) {
        super.func_94581_a(ir);
        this.iconDepth = ir.func_94245_a(this.func_111208_A() + "-depth");
        this.iconOrnament = ir.func_94245_a("Automagy:focus_orn_transposing");
    }

    public AspectList getVisCost(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, gratis) ? visCostEmpty : visCost;
    }

    public int getFocusColor(ItemStack focusstack) {
        return 0x4CC14C;
    }

    public IIcon getFocusDepthLayerIcon(ItemStack focusstack) {
        return this.iconDepth;
    }

    public IIcon getOrnament(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, transposing) ? this.iconOrnament : null;
    }

    public String getSortingHelper(ItemStack focusstack) {
        return "ACRAFT" + super.getSortingHelper(focusstack);
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        ArrayList<FocusUpgradeType> list = new ArrayList<FocusUpgradeType>();
        if (!this.isUpgradedWith(focusstack, gratis)) {
            list.add(gratis);
        }
        if (!this.isUpgradedWith(focusstack, storage)) {
            list.add(storage);
        }
        if (!this.isUpgradedWith(focusstack, transposing)) {
            list.add(transposing);
        }
        return list.size() > 0 ? list.toArray(new FocusUpgradeType[list.size()]) : null;
    }

    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return ThaumcraftExtension.isResearchComplete(player, "FOCUSCRAFTING_UPGRADE");
    }

    public void addFocusInformation(ItemStack focusstack, EntityPlayer player, List list, boolean par4) {
        LinkedHashMap<Short, Integer> map = new LinkedHashMap<Short, Integer>();
        for (short id : this.getAppliedUpgrades(focusstack)) {
            if (id < 0) continue;
            int amt = 1;
            if (map.containsKey(id)) {
                amt = (Integer)map.get(id) + 1;
            }
            map.put(id, amt);
        }
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            Short id = (Short)object.next();
            String s = EnumChatFormatting.DARK_PURPLE + FocusUpgradeType.types[id].getLocalizedName() + ((Integer)map.get(id) > 1 ? " " + StatCollector.func_74838_a((String)("enchantment.level." + map.get(id))) : "");
            if (id == ItemFocusCrafting.storage.id) {
                int count = 0;
                InventoryForItem inv = new InventoryForItem(focusstack, "Focus Inventory", 11);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (inv.func_70301_a(i) == null) continue;
                    ++count;
                }
                if (count > 0) {
                    if (count == 1) {
                        if (count > 0) {
                            s = s + " " + EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)"Automagy.tip.focusCrafting.stored1");
                        }
                    } else {
                        s = s + " " + EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74837_a((String)"Automagy.tip.focusCrafting.stored", (Object[])new Object[]{count});
                    }
                }
            }
            list.add(s);
        }
    }

    public ItemStack onFocusRightClick(ItemStack wandstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        if (!world.field_72995_K) {
            this.openGUI(player, wandstack, player.field_71071_by.field_70461_c);
        } else if (!this.canPerformFunction(player, wandstack, false)) {
            player.func_85030_a("thaumcraft:wandfail", 0.1f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.1f);
        }
        return wandstack;
    }

    public boolean canPerformFunction(EntityPlayer player, ItemStack wand, boolean doConsumeVis) {
        ItemStack focusstack = ((ItemWandCasting)wand.func_77973_b()).getFocusItem(wand);
        return this.isUpgradedWith(focusstack, gratis) || ThaumcraftApiHelper.consumeVisFromWand((ItemStack)wand, (EntityPlayer)player, (AspectList)visCost, (boolean)doConsumeVis, (boolean)false);
    }

    public void openGUI(EntityPlayer player, ItemStack wand, int slot) {
        if (this.canPerformFunction(player, wand, true)) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Automagy.instance, (int)14, (World)player.field_70170_p, (int)slot, (int)-1, (int)0);
        }
    }

    public static boolean isWandWithCraftingFocus(ItemStack stack) {
        if (stack != null) {
            return ThaumcraftExtension.getWandFocus(stack) instanceof ItemFocusCrafting;
        }
        return false;
    }

    public static ItemFocusCrafting getCraftingFocusOnWand(ItemStack stack) {
        ItemFocusBasic focus;
        if (stack != null && (focus = ThaumcraftExtension.getWandFocus(stack)) instanceof ItemFocusCrafting) {
            return (ItemFocusCrafting)focus;
        }
        return null;
    }

    public static boolean wandHasRequiredVis(EntityPlayer player, ItemStack wandstack, boolean useDefaultCostIfWrongFocus) {
        ItemFocusCrafting focus = ItemFocusCrafting.getCraftingFocusOnWand(wandstack);
        if (focus == null) {
            if (useDefaultCostIfWrongFocus) {
                return ThaumcraftApiHelper.consumeVisFromWand((ItemStack)wandstack, (EntityPlayer)player, (AspectList)visCost, (boolean)false, (boolean)false);
            }
            return false;
        }
        return focus.canPerformFunction(player, wandstack, false);
    }

    public static ItemStack takeTransposingCraftingFocusForPlayer(EntityPlayer player, ItemStack oldFocus, boolean doit) {
        IInventory baubles;
        ItemStack result = ItemFocusCrafting.takeTransposingCraftingFocusForInventory((IInventory)player.field_71071_by, oldFocus, doit);
        if (result == null && (baubles = BaublesApi.getBaubles((EntityPlayer)player)) != null) {
            result = ItemFocusCrafting.takeTransposingCraftingFocusForInventory(baubles, oldFocus, doit);
        }
        return result;
    }

    public static ItemStack takeTransposingCraftingFocusForInventory(IInventory inv, ItemStack oldFocus, boolean doit) {
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (item instanceof ItemFocusCrafting) {
                if (!((ItemFocusCrafting)item).isUpgradedWith(stack, transposing)) continue;
                if (doit) {
                    inv.func_70299_a(i, oldFocus);
                }
                return stack;
            }
            if (!(item instanceof ItemFocusPouch)) continue;
            ItemFocusPouch pouch = (ItemFocusPouch)item;
            ItemStack[] pouchInv = pouch.getInventory(stack);
            for (int j = 0; j < pouchInv.length; ++j) {
                Item itemInPouch;
                ItemStack stackInPouch = pouchInv[j];
                if (stackInPouch == null || !((itemInPouch = stackInPouch.func_77973_b()) instanceof ItemFocusCrafting) || !((ItemFocusCrafting)itemInPouch).isUpgradedWith(stackInPouch, transposing)) continue;
                if (doit) {
                    pouchInv[j] = oldFocus;
                    pouch.setInventory(stack, pouchInv);
                    inv.func_70299_a(i, stack);
                }
                return stackInPouch;
            }
        }
        return null;
    }
}

