/*
 * Decompiled with CFR 0.152.
 */
package xonin.backhand.utils;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="backhand", category="client")
@Config.Comment(value={"Configs that only affect the client and have no change on the server"})
public class BackhandConfigClient {
    @Config.Comment(value={"If set to false, an empty offhand will only be rendered when the player is punching with the offhand."})
    @Config.DefaultBoolean(value=false)
    public static boolean RenderEmptyOffhandAtRest;
    @Config.Comment(value={"If set to false, the offhand hotbar slot will only be rendered when the offhand is not empty."})
    @Config.DefaultBoolean(value=false)
    public static boolean RenderOffhandHotbarSlotWhenEmpty;
    @Config.RangeInt(min=-2000, max=2000)
    @Config.DefaultInt(value=0)
    public static int offhandHotbarSlotXOffset;
    @Config.RangeInt(min=0, max=1000)
    @Config.DefaultInt(value=0)
    public static int offhandHotbarSlotYOffset;
    @Config.Comment(value={"Tweaks when holding a torch in the offhand"})
    @Config.Name(value="Offhand Torch Tweaks")
    public static TorchConfig torchConfig;

    static {
        torchConfig = new TorchConfig();
    }

    public static class TorchConfig {
        @Config.Comment(value={"These items will be count as torches\nFormatting of an item should be: modid:itemname\nThese should all be placed on separate lines between the provided '<' and '>'.\n"})
        @Config.DefaultStringList(value={"minecraft:torch", "minecraft:redstone_torch"})
        public String[] torch_items;
        @Config.Name(value="No Offhand Torch With Block")
        @Config.Comment(value={"Don't place torches from the offhand if the main hand has a block that can be placed"})
        @Config.DefaultBoolean(value=false)
        public boolean noTorchWithBlock;
        @Config.Name(value="No Offhand Torch With Empty Hand")
        @Config.Comment(value={"Don't place torches from the offhand if the main hand is empty"})
        @Config.DefaultBoolean(value=false)
        public boolean noTorchWithEmpty;
        @Config.Name(value="No Offhand Torch With Food")
        @Config.Comment(value={"Don't place torches from the offhand if the main hand has food"})
        @Config.DefaultBoolean(value=false)
        public boolean noTorchWithFood;
        @Config.Name(value="No Offhand Torch At All")
        @Config.Comment(value={"Don't place torches from the offhand at all", "Note: This overrides all other options"})
        @Config.DefaultBoolean(value=false)
        public boolean noTorchAtAll;
        @Config.Name(value="Offhand Torch With Tool Only")
        @Config.Comment(value={"Don't place torches from the offhand unless the main hand contains a tool", "Vanilla tools include swords, hoes, axes, and pickaxes", "Modded tools include Tinker's Construct tools (not weapons)"})
        @Config.DefaultBoolean(value=false)
        public boolean offhandTorchWithToolOnly;
        @Config.Name(value="Don't Use Last Offhand Torch")
        @Config.Comment(value={"Don't place torches from the offhand if it is the last torch in your offhand"})
        @Config.DefaultBoolean(value=false)
        public boolean noLastTorch;
    }
}

