/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat.cthandlers;

import ganymedes01.etfuturum.api.CompostingRegistry;
import ganymedes01.etfuturum.compat.CompatCraftTweaker;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.etfuturum.composting")
public class CTComposting {
    @ZenMethod
    public static void remove(IIngredient stack) {
        Object internal = CompatCraftTweaker.getInternal(stack);
        if (internal instanceof String && CompostingRegistry.isCompostable((String)internal) || internal instanceof ItemStack && CompostingRegistry.isCompostable((ItemStack)internal)) {
            ItemStackMap<Integer> toRemove = new ItemStackMap<Integer>();
            for (Map.Entry<ItemStack, Integer> compostEntry : CompostingRegistry.getComposts().entrySet()) {
                if (!stack.matches((IItemStack)new MCItemStack(compostEntry.getKey()))) continue;
                toRemove.put(compostEntry.getKey(), compostEntry.getValue());
            }
            MineTweakerAPI.apply((IUndoableAction)new RemoveAction(toRemove));
        } else {
            MineTweakerAPI.logWarning((String)("No compostables for " + stack));
        }
    }

    @ZenMethod
    public static void addCompostable(IIngredient stack, int count) {
        List items = stack.getItems();
        if (items == null) {
            MineTweakerAPI.logError((String)("Cannot make " + stack + " compostable"));
            return;
        }
        ItemStack[] toAdd = CompatCraftTweaker.getItemStacks(items);
        MineTweakerAPI.apply((IUndoableAction)new AddAction(stack, toAdd, count));
    }

    @ZenMethod
    public static void removeAll() {
        MineTweakerAPI.apply((IUndoableAction)new RemoveAllAction());
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final ItemStackMap<Integer> items;

        public RemoveAction(ItemStackMap<Integer> items) {
            this.items = items;
        }

        public void apply() {
            for (ItemStack item : this.items.keySet()) {
                CompostingRegistry.remove(item);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (Map.Entry<ItemStack, Integer> entry : this.items.entrySet()) {
                CompostingRegistry.registerCompostable(entry.getKey(), (int)entry.getValue());
            }
        }

        public String describe() {
            return "Removing " + this.items.size() + " compostables";
        }

        public String describeUndo() {
            return "Restoring " + this.items.size() + " compostables";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] stacks;
        private final int count;

        public AddAction(IIngredient ingredient, ItemStack[] stacks, int count) {
            this.ingredient = ingredient;
            this.stacks = stacks;
            this.count = count;
        }

        public void apply() {
            for (ItemStack inputStack : this.stacks) {
                CompostingRegistry.registerCompostable(inputStack, this.count);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack inputStack : this.stacks) {
                CompostingRegistry.remove(inputStack);
            }
        }

        public String describe() {
            return "Making " + this.ingredient + " compostable";
        }

        public String describeUndo() {
            return "Making " + this.ingredient + " compostable";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveAllAction
    implements IUndoableAction {
        private final ItemStackMap<Integer> items;

        public RemoveAllAction() {
            ItemStackMap items = new ItemStackMap();
            items.putAll(CompostingRegistry.getComposts());
            this.items = items;
        }

        public void apply() {
            for (ItemStack item : this.items.keySet()) {
                CompostingRegistry.remove(item);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (Map.Entry<ItemStack, Integer> entry : this.items.entrySet()) {
                CompostingRegistry.registerCompostable(entry.getKey(), (int)entry.getValue());
            }
        }

        public String describe() {
            return "Removing " + this.items.size() + " compostables";
        }

        public String describeUndo() {
            return "Restoring " + this.items.size() + " compostables";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

