/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.CustomSlot;
import binnie.core.craftgui.minecraft.InventoryType;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.WindowInventory;
import binnie.core.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.core.craftgui.minecraft.control.ControlSlotArray;
import binnie.core.craftgui.minecraft.control.ControlSlotBase;
import binnie.core.craftgui.minecraft.control.EnumHighlighting;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.util.I18N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;

public class ControlSlot
extends ControlSlotBase {
    public static Map<EnumHighlighting, List<Integer>> highlighting = new HashMap<EnumHighlighting, List<Integer>>();
    public static boolean shiftClickActive = false;
    public Slot slot;

    public ControlSlot(IWidget parent, float x, float y) {
        super(parent, x, y);
        this.slot = null;
        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (ControlSlot.this.slot == null) {
                    return;
                }
                PlayerControllerMP playerController = ((Window)ControlSlot.this.getSuperParent()).getGui().getMinecraft().field_71442_b;
                int windowId = ((Window)ControlSlot.this.getSuperParent()).getContainer().field_75152_c;
                int slotNumber = ControlSlot.this.slot.field_75222_d;
                int button = event.getButton();
                ((Window)Window.get(ControlSlot.this.getWidget())).getGui();
                playerController.func_78753_a(windowId, slotNumber, button, GuiScreen.func_146272_n() ? 1 : 0, (EntityPlayer)((Window)ControlSlot.this.getSuperParent()).getGui().getMinecraft().field_71439_g);
            }
        });
    }

    public ControlSlot(IWidget parent, int x, int y, Slot slot) {
        super(parent, x, y);
        this.slot = slot;
    }

    @Override
    public void onRenderBackground() {
        IIcon icon;
        CraftGUI.render.texture((Object)CraftGUITexture.Slot, IPoint.ZERO);
        if (this.slot == null) {
            return;
        }
        InventorySlot islot = this.getInventorySlot();
        if (islot != null && islot.getValidator() != null && (icon = islot.getValidator().getIcon(!islot.getInputSides().isEmpty())) != null) {
            CraftGUI.render.iconItem(new IPoint(1.0f, 1.0f), icon);
        }
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlight.getKey() == EnumHighlighting.SHIFT_CLICK && !shiftClickActive || highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = -1442840576 + Math.min(highlight.getKey().getColour(), 0xFFFFFF);
            CraftGUI.render.gradientRect(new IArea(1.0f, 1.0f, 16.0f, 16.0f), c, c);
        }
        if (!highlighted && this.getSuperParent().getMousedOverWidget() == this) {
            if (((Window)Window.get(this)).getGui().getDraggedItem() != null && !this.slot.func_75214_a(((Window)Window.get(this)).getGui().getDraggedItem())) {
                CraftGUI.render.gradientRect(new IArea(1.0f, 1.0f, 16.0f, 16.0f), -1426089575, -1426089575);
            } else {
                CraftGUI.render.gradientRect(new IArea(1.0f, 1.0f, 16.0f, 16.0f), -2130706433, -2130706433);
            }
        }
    }

    @Override
    public void onRenderOverlay() {
        if (this.slot == null) {
            return;
        }
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlight.getKey() == EnumHighlighting.SHIFT_CLICK && !shiftClickActive || highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = highlight.getKey().getColour();
            IArea area = this.getArea();
            if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
                area = this.getParent().getArea();
                area.setPosition(IPoint.ZERO.sub(this.getPosition()));
            }
            CraftGUI.render.color(c);
            CraftGUI.render.texture((Object)CraftGUITexture.Outline, area.outset(1));
        }
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.slot == null) {
            return;
        }
        if (this.isMouseOver() && GuiScreen.func_146272_n()) {
            ((Window)Window.get(this)).getContainer().setMouseOverSlot(this.slot);
            shiftClickActive = true;
        }
        if (((Window)Window.get(this)).getGui().isHelpMode() && this.isMouseOver()) {
            for (ControlSlot slot2 : this.getControlSlots()) {
                if (slot2.slot == null) continue;
                highlighting.get((Object)EnumHighlighting.HELP).add(slot2.slot.field_75222_d);
            }
        }
    }

    private List<ControlSlot> getControlSlots() {
        ArrayList<ControlSlot> slots = new ArrayList<ControlSlot>();
        if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
            for (IWidget child : this.getParent().getWidgets()) {
                slots.add((ControlSlot)child);
            }
        } else {
            slots.add(this);
        }
        return slots;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.slot != null) {
            return this.slot.func_75211_c();
        }
        return null;
    }

    public ControlSlot assignAndRegister(InventoryType inventoryType, int slotIndex) {
        NBTTagList actions = new NBTTagList();
        this.assign(actions, inventoryType, slotIndex);
        MessageCraftGUI.sendToServer(actions);
        return this;
    }

    public ControlSlot assign(NBTTagList actions, InventoryType inventoryType, int slotIndex) {
        if (this.slot == null) {
            this.slot = ((Window)this.getSuperParent()).getContainer().getOrCreateSlot(inventoryType, slotIndex);
        }
        NBTTagCompound slotReg = new NBTTagCompound();
        slotReg.func_74778_a("type", "slot-reg");
        slotReg.func_74774_a("t", (byte)inventoryType.ordinal());
        slotReg.func_74777_a("i", (short)slotIndex);
        slotReg.func_74777_a("n", (short)this.slot.field_75222_d);
        actions.func_74742_a((NBTBase)slotReg);
        return this;
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        if (this.slot == null) {
            return;
        }
        InventorySlot slot = this.getInventorySlot();
        if (this.getInventorySlot() != null) {
            tooltip.add(slot.getName());
            tooltip.add(I18N.localise("binniecore.gui.side.insertSide", MachineSide.asString(slot.getInputSides())));
            tooltip.add(I18N.localise("binniecore.gui.side.extractSide", MachineSide.asString(slot.getOutputSides())));
            if (slot.isReadOnly()) {
                tooltip.add(I18N.localise("binniecore.gui.slot.pickupOnly"));
            }
            if (slot.getValidator() == null) {
                tooltip.add(I18N.localise("binniecore.gui.slot.accepts", I18N.localise("binniecore.gui.slot.anyItem")));
            } else {
                tooltip.add(I18N.localise("binniecore.gui.slot.accepts", slot.getValidator().getTooltip()));
            }
        } else if (this.slot.field_75224_c instanceof WindowInventory) {
            SlotValidator s = ((WindowInventory)this.slot.field_75224_c).getValidator(this.slot.getSlotIndex());
            if (s == null) {
                tooltip.add(I18N.localise("binniecore.gui.slot.accepts", I18N.localise("binniecore.gui.slot.anyItem")));
            } else {
                tooltip.add(I18N.localise("binniecore.gui.slot.accepts", s.getTooltip()));
            }
        } else if (this.slot.field_75224_c instanceof InventoryPlayer) {
            tooltip.add(I18N.localise("binniecore.gui.slot.playerInventory"));
        }
    }

    public InventorySlot getInventorySlot() {
        return this.slot instanceof CustomSlot ? ((CustomSlot)this.slot).getInventorySlot() : null;
    }

    static {
        for (EnumHighlighting h : EnumHighlighting.values()) {
            highlighting.put(h, new ArrayList());
        }
    }
}

