/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.weaponry;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.expanded.IBaubleExpanded;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import tconstruct.compat.LoadedMods;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.tools.TinkerTools;

@Optional.InterfaceList(value={@Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.weapons.IBattlegearWeapon"), @Optional.Interface(modid="Baubles|Expanded", iface="baubles.api.expanded.IBaubleExpanded"), @Optional.Interface(modid="Baubles", iface="baubles.api.IBauble")})
public abstract class AmmoItem
extends ToolCore
implements IBattlegearWeapon,
IAmmo,
IBauble,
IBaubleExpanded {
    public AmmoItem(int baseDamage, String name) {
        super(baseDamage);
        this.func_77637_a(TConstructRegistry.weaponryTab);
    }

    @Override
    public int getAmmoCount(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        return tags.func_74762_e("Ammo");
    }

    @Override
    public int getMaxAmmo(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        return this.getMaxAmmo(tags);
    }

    @Override
    public int getMaxAmmo(NBTTagCompound tags) {
        float dur = tags.func_74762_e("TotalDurability");
        return Math.max(1, (int)Math.ceil(dur * this.getAmmoModifier()));
    }

    @Override
    public int addAmmo(int toAdd, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return toAdd;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        int oldCount = tags.func_74762_e("Ammo");
        int newCount = Math.min(oldCount + toAdd, this.getMaxAmmo(stack));
        tags.func_74768_a("Ammo", newCount);
        return toAdd - (newCount - oldCount);
    }

    @Override
    public int consumeAmmo(int toUse, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return toUse;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        int oldCount = tags.func_74762_e("Ammo");
        int newCount = Math.max(oldCount - toUse, 0);
        tags.func_74768_a("Ammo", newCount);
        return toUse - (oldCount - newCount);
    }

    @Override
    public void setAmmo(int count, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        tags.func_74768_a("Ammo", count);
    }

    public float getAmmoModifier() {
        return 0.1f;
    }

    public boolean pickupAmmo(ItemStack stack, ItemStack candidate, EntityPlayer player) {
        ItemStack[] itemStackArray;
        if (stack.func_77973_b() == null || !stack.func_77942_o() || !((itemStackArray = stack.func_77973_b()) instanceof IAmmo)) {
            return false;
        }
        IAmmo pickedup = (IAmmo)itemStackArray;
        if (candidate != null && this.tryStackAmmo(stack, pickedup, candidate)) {
            return true;
        }
        for (ItemStack invItem : player.field_71071_by.field_70462_a) {
            if (!this.tryStackAmmo(stack, pickedup, invItem)) continue;
            return true;
        }
        if (LoadedMods.baubles) {
            for (ItemStack bauble : PlayerHandler.getPlayerBaubles((EntityPlayer)player).stackList) {
                if (!this.tryStackAmmo(stack, pickedup, bauble)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryStackAmmo(ItemStack stack, IAmmo pickedup, ItemStack bauble) {
        if (!this.testIfAmmoMatches(stack, bauble)) {
            return false;
        }
        IAmmo ininventory = (IAmmo)bauble.func_77973_b();
        int count = pickedup.getAmmoCount(stack);
        return count != ininventory.addAmmo(count, bauble);
    }

    private boolean testIfAmmoMatches(ItemStack reference, ItemStack candidate) {
        if (candidate == null) {
            return false;
        }
        if (!candidate.func_77942_o() || !candidate.func_77978_p().func_74764_b("InfiTool")) {
            return false;
        }
        if (reference.func_77973_b() != candidate.func_77973_b()) {
            return false;
        }
        NBTTagCompound referenceTags = this.getComparisonTags(reference);
        NBTTagCompound testTags = this.getComparisonTags(candidate);
        return referenceTags.equals((Object)testTags);
    }

    private NBTTagCompound getComparisonTags(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        NBTTagCompound out = new NBTTagCompound();
        this.copyTag(out, tags, "Head");
        this.copyTag(out, tags, "Handle");
        this.copyTag(out, tags, "Accessory");
        this.copyTag(out, tags, "Extra");
        this.copyTag(out, tags, "RenderHead");
        this.copyTag(out, tags, "RenderHandle");
        this.copyTag(out, tags, "RenderAccessory");
        this.copyTag(out, tags, "RenderExtra");
        this.copyTag(out, tags, "TotalDurability");
        this.copyTag(out, tags, "Attack");
        this.copyTag(out, tags, "MiningSpeed");
        this.copyTag(out, tags, "HarvestLevel");
        this.copyTag(out, tags, "Modifiers");
        return out;
    }

    private void copyTag(NBTTagCompound out, NBTTagCompound in, String tag) {
        if (in.func_74764_b(tag)) {
            out.func_74768_a(tag, in.func_74762_e(tag));
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack off) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        event.cancelParent = false;
        event.swingOffhand = false;
        event.shouldAttack = false;
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        event.setCanceled(false);
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        event.setCanceled(false);
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side effectiveSide, ItemStack mainhandItem, ItemStack offhandItem) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack mainhand, ItemStack offhand) {
        if (offhand == null) {
            return true;
        }
        return mainhand != null && mainhand.func_77973_b() != TinkerTools.cleaver && mainhand.func_77973_b() != TinkerTools.battleaxe && offhand.func_77973_b() != TinkerTools.cleaver && offhand.func_77973_b() != TinkerTools.battleaxe;
    }

    @Optional.Method(modid="Baubles|Expanded")
    public String[] getBaubleTypes(ItemStack itemstack) {
        return new String[]{"quiver"};
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        this.func_77663_a(itemstack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> lines, boolean advanced) {
        super.func_77624_a(stack, player, lines, advanced);
        if (LoadedMods.baubles) {
            this.addBaubleInformation(lines);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="Baubles")
    private void addBaubleInformation(List<String> lines) {
        if (LoadedMods.baublesExpanded) {
            if (GuiScreen.func_146272_n()) {
                lines.add(StatCollector.func_74838_a((String)"tooltip.compatibleslots"));
                lines.add(StatCollector.func_74838_a((String)"slot.quiver"));
                if (LoadedMods.tiCTooltips) {
                    lines.add("");
                }
            } else if (!LoadedMods.tiCTooltips) {
                lines.add(StatCollector.func_74838_a((String)"tooltip.shiftprompt"));
            }
        } else {
            lines.add(StatCollector.func_74838_a((String)"baubletype.any"));
        }
    }
}

