/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.guis;

import gcewing.sg.SGCraft;
import gcewing.sg.guis.BaseGui;
import gcewing.sg.guis.Widget;
import gcewing.sg.guis.screens.Screen;
import gcewing.sg.interfaces.IWidget;
import gcewing.sg.interfaces.IWidgetContainer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class Group
extends Widget
implements IWidgetContainer {
    protected List<IWidget> widgets = new ArrayList<IWidget>();
    protected IWidget focus;

    @Override
    public IWidget getFocus() {
        return this.focus;
    }

    @Override
    public void setFocus(IWidget widget) {
        SGCraft.log.trace(String.format("BaseGui.Group.setFocus: of %s to %s", this.getClass().getSimpleName(), widget.getClass().getSimpleName()));
        this.focus = widget;
    }

    public void add(int left, int top, IWidget widget) {
        widget.setLeft(left);
        widget.setTop(top);
        widget.setParent(this);
        this.widgets.add(widget);
    }

    public void remove(IWidget widget) {
        this.widgets.remove(widget);
        if (this.getFocus() != widget) {
            return;
        }
        if (BaseGui.isFocused(this)) {
            BaseGui.tellFocusChanged(widget, false);
        }
        this.setFocus(null);
    }

    @Override
    public void draw(Screen scr, int mouseX, int mouseY) {
        super.draw(scr, mouseX, mouseY);
        for (IWidget w : this.widgets) {
            int dx = w.left();
            int dy = w.top();
            GL11.glPushMatrix();
            GL11.glTranslated((double)dx, (double)dy, (double)0.0);
            w.draw(scr, mouseX - dx, mouseY - dy);
            GL11.glPopMatrix();
        }
    }

    @Override
    public IWidget dispatchMousePress(int x, int y, int button) {
        SGCraft.log.trace(String.format("BaseGui.Group.dispatchMousePress: (%s, %s) in %s", x, y, this.getClass().getSimpleName()));
        IWidget target = this.findWidget(x, y);
        if (target != null) {
            return target.dispatchMousePress(x - target.left(), y - target.top(), button);
        }
        return this;
    }

    @Override
    public boolean dispatchKeyPress(char c, int key) {
        IWidget focus = this.getFocus();
        if (focus != null && focus.dispatchKeyPress(c, key)) {
            return true;
        }
        return super.dispatchKeyPress(c, key);
    }

    public IWidget findWidget(int x, int y) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            IWidget w = this.widgets.get(i);
            int l = w.left();
            int t = w.top();
            if (x < l || y < t || x >= l + w.width() || y >= t + w.height()) continue;
            return w;
        }
        return null;
    }

    @Override
    public void layout() {
        for (IWidget w : this.widgets) {
            w.layout();
        }
    }
}

