/*
 * Decompiled with CFR 0.152.
 */
package serverutils.aurora.tag;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import serverutils.aurora.tag.Tag;
import serverutils.aurora.tag.TagBase;
import serverutils.aurora.tag.TextTag;

public class PairedTag
extends Tag {
    public List<TagBase> children;

    public PairedTag(String n, String t) {
        super(n);
        if (!t.isEmpty()) {
            this.append(new TextTag(t));
        }
    }

    public PairedTag(String n) {
        super(n);
    }

    @Override
    public void build(StringBuilder builder) {
        builder.append('<');
        builder.append(this.name);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            for (Map.Entry map : this.attributes.entrySet()) {
                builder.append(' ');
                builder.append((String)map.getKey());
                builder.append('=');
                builder.append('\"');
                builder.append((String)map.getValue());
                builder.append('\"');
            }
        }
        builder.append('>');
        if (this.children != null && !this.children.isEmpty()) {
            for (TagBase child : this.children) {
                child.build(builder);
            }
        }
        builder.append('<');
        builder.append('/');
        builder.append(this.name);
        builder.append('>');
    }

    @Override
    public <T extends TagBase> T append(T child) {
        if (this.children == null) {
            this.children = new LinkedList<TagBase>();
        }
        this.children.add(child);
        child.parent = this;
        return child;
    }
}

