/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.client.ClientUtils;
import WayofTime.alchemicalWizardry.client.nei.NEIConfig;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class NEICalcinatorHandler
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alchemicalwizardry.calcinator") && ((Object)((Object)this)).getClass() == NEICalcinatorHandler.class) {
            for (ReagentStack reagent : ReagentRegistry.itemToReagentMap.values()) {
                this.arecipes.add(new CachedReagentInfo(reagent));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        this.checkReagents(result);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.checkReagents(ingredient);
    }

    private void checkReagents(ItemStack result) {
        ReagentStack rs = ReagentRegistry.getReagentStackForItem(result);
        if (rs != null) {
            this.arecipes.add(new CachedReagentInfo(rs));
            return;
        }
        NBTTagCompound tagCompound = result.func_77978_p();
        if (tagCompound == null || tagCompound.func_82582_d()) {
            return;
        }
        NBTTagList tagList = tagCompound.func_150295_c("reagentTanks", 10);
        if (tagList.field_74747_a.isEmpty()) {
            return;
        }
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack reagentItem;
            ReagentStack reagentStackForItem;
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            ReagentStack reagent = ReagentContainer.readFromNBT(savedTag).getReagent();
            if (reagent == null || (reagentStackForItem = ReagentRegistry.getReagentStackForItem(reagentItem = ReagentRegistry.getItemForReagent(reagent.reagent))) == null) continue;
            this.arecipes.add(new CachedReagentInfo(reagentStackForItem));
        }
    }

    public int recipiesPerPage() {
        return 5;
    }

    public void drawExtras(int recipe) {
        CachedReagentInfo reagentInfo = (CachedReagentInfo)((Object)this.arecipes.get(recipe));
        reagentInfo.onDraw(30, 0);
    }

    public String getOverlayIdentifier() {
        return "alchemicalwizardry.calcinator";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(55, 18, 24, 17), "alchemicalwizardry.calcinator", new Object[0]));
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/calcinator.png").toString();
    }

    public String getRecipeName() {
        return "Alchemic Calcinator";
    }

    public class CachedReagentInfo
    extends TemplateRecipeHandler.CachedRecipe {
        private final Reagent reagent;
        private final PositionedStack stack;
        private final PositionedStack orbs;
        private final int amount;
        private final String amountText;
        private final int amountTextWidth;
        private final String nameText;
        private final int nameTextWidth;
        private static final int ARROW_WIDTH = 24;
        private static final int ARROW_HEIGHT = 16;
        private static final int FILL_TIME = 192;
        private static final int HOLD_TIME = 8;

        public CachedReagentInfo(ReagentStack reagent) {
            super((TemplateRecipeHandler)NEICalcinatorHandler.this);
            this.reagent = reagent.reagent;
            this.stack = new PositionedStack((Object)ReagentRegistry.getItemForReagent(reagent.reagent), 32, 6);
            this.amount = reagent.amount;
            ItemStack[] orbStacks = (ItemStack[])NEIConfig.getBloodOrbs().stream().map(ItemStack::new).toArray(ItemStack[]::new);
            this.orbs = new PositionedStack((Object)orbStacks, 32, 33);
            this.amountText = String.format("%,d AR", this.amount);
            this.amountTextWidth = GuiDraw.fontRenderer.func_78256_a(this.amountText);
            this.nameText = this.reagent.name;
            this.nameTextWidth = GuiDraw.fontRenderer.func_78256_a(this.nameText);
        }

        public PositionedStack getResult() {
            return this.stack;
        }

        public Reagent getReagent() {
            return this.reagent;
        }

        public int getAmount() {
            return this.amount;
        }

        public void onDraw(int x, int y) {
            this.drawColoredProgressBar(x, y);
            int textX = x + 84 - this.amountTextWidth / 2;
            int textY = y + 19;
            GuiDraw.fontRenderer.func_78276_b(this.amountText, textX, textY, 0);
            textX = x + 84 - this.nameTextWidth / 2;
            int color = this.reagent.getColourRed() << 16 | this.reagent.getColourGreen() << 8 | this.reagent.getColourBlue();
            GuiDraw.fontRenderer.func_78276_b(this.nameText, textX, textY += 10, color);
        }

        private void drawColoredProgressBar(int x, int y) {
            int arrowX = x + 25;
            int arrowY = y + 19;
            int totalCycle = 200;
            int cycleTick = NEICalcinatorHandler.this.cycleticks % totalCycle;
            int fillWidth = cycleTick < 192 ? cycleTick * 24 / 192 : 24;
            TextureManager texManager = ClientUtils.mc.func_110434_K();
            texManager.func_110577_a(NEIConfig.ARROW_TEXTURE);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4ub((byte)((byte)this.reagent.getColourRed()), (byte)((byte)this.reagent.getColourGreen()), (byte)((byte)this.reagent.getColourBlue()), (byte)-1);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)arrowX, (double)(arrowY + 16), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(arrowX + fillWidth), (double)(arrowY + 16), 0.0, (double)((float)fillWidth / 24.0f), 1.0);
            tessellator.func_78374_a((double)(arrowX + fillWidth), (double)arrowY, 0.0, (double)((float)fillWidth / 24.0f), 0.0);
            tessellator.func_78374_a((double)arrowX, (double)arrowY, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEICalcinatorHandler.this.cycleticks / 20, Collections.singletonList(this.orbs));
        }
    }
}

