/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import com.google.common.collect.ImmutableList;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.mixin.interfaces.MTELinkedInputBusExt;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasInventory;
import gregtech.api.metatileentity.implementations.MTEBasicBatteryBuffer;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchTurbine;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.hatch.MTEHatchRack;

public enum InventoryAdapter {
    QCRack{

        @Override
        public boolean canHandle(IInventory inv) {
            IGregTechTileEntity igte;
            IMetaTileEntity imte;
            return inv instanceof IGregTechTileEntity && (imte = (igte = (IGregTechTileEntity)inv).getMetaTileEntity()) instanceof MTEHatchRack;
        }

        @Override
        public int getSizeInventory(IInventory inv) {
            return 4;
        }

        @Override
        public boolean isValidSlot(IInventory inv, int slot) {
            return slot >= 0 && slot < 4;
        }

        @Override
        public boolean validate(BlockAnalyzer.IBlockApplyContext context, IInventory inv) {
            IGregTechTileEntity igte = (IGregTechTileEntity)inv;
            MTEHatchRack rack = (MTEHatchRack)igte.getMetaTileEntity();
            if (rack.heat > 2000) {
                context.error("QC Rack is too hot to extract or insert items");
                return false;
            }
            if (igte.isActive()) {
                context.error("Cannot extract or insert items from/into QC Rack while the QC is on");
                return false;
            }
            return true;
        }
    }
    ,
    GTUnrestricted{

        @Override
        public boolean canHandle(IInventory inv) {
            if (inv instanceof IGregTechTileEntity) {
                IGregTechTileEntity igte = (IGregTechTileEntity)inv;
                IMetaTileEntity imte = igte.getMetaTileEntity();
                if (imte instanceof MTEHatchOutputBusME) {
                    return true;
                }
                if (imte instanceof MTEHatchOutputME) {
                    return true;
                }
                if (imte instanceof MTEMultiBlockBase) {
                    return true;
                }
                if (imte instanceof MTEBasicBatteryBuffer) {
                    return true;
                }
                if (imte instanceof MTEHatchTurbine) {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    GTLinkedInputBus{

        @Override
        public boolean canHandle(IInventory inv) {
            if (inv instanceof IGregTechTileEntity) {
                IGregTechTileEntity igte = (IGregTechTileEntity)inv;
                if (igte.isDead()) {
                    return false;
                }
                IMetaTileEntity imte = igte.getMetaTileEntity();
                return imte instanceof MTELinkedInputBusExt;
            }
            return false;
        }

        @Override
        public boolean isValidSlot(IInventory inv, int slot) {
            IGregTechTileEntity igte = (IGregTechTileEntity)inv;
            MTELinkedInputBusExt inputBus = (MTELinkedInputBusExt)igte.getMetaTileEntity();
            return inputBus.mm$getChannelRefCount() == 1 && super.isValidSlot(inv, slot);
        }
    }
    ,
    GTNoop{

        @Override
        public boolean canHandle(IInventory inv) {
            if (inv instanceof IGregTechTileEntity) {
                IGregTechTileEntity igte = (IGregTechTileEntity)inv;
                if (igte.isDead()) {
                    return false;
                }
                IMetaTileEntity imte = igte.getMetaTileEntity();
                if (imte == null) {
                    return false;
                }
                if (imte.getClass() == MTEHatchOutputBus.class) {
                    return true;
                }
                if (imte.getClass() == MTEHatchInputBus.class) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getSizeInventory(IInventory inv) {
            return 0;
        }

        @Override
        public boolean isValidSlot(IInventory inv, int slot) {
            return false;
        }

        @Override
        public boolean canExtract(IInventory inv, int slot) {
            return false;
        }

        @Override
        public boolean canInsert(IInventory inv, int slot, ItemStack stack) {
            return false;
        }

        @Override
        public boolean insert(IInventory inv, int slot, ItemStack stack) {
            return false;
        }

        @Override
        public ItemStack extract(IInventory inv, int slot) {
            return null;
        }
    }
    ,
    GT{

        @Override
        public boolean canHandle(IInventory inv) {
            return inv instanceof IHasInventory;
        }

        @Override
        public boolean isValidSlot(IInventory inv, int slot) {
            return ((IHasInventory)inv).isValidSlot(slot);
        }

        @Override
        public boolean canExtract(IInventory inv, int slot) {
            return ((IHasInventory)inv).func_102008_b(slot, inv.func_70301_a(slot), ForgeDirection.UNKNOWN.ordinal());
        }

        @Override
        public boolean canInsert(IInventory inv, int slot, ItemStack stack) {
            return ((IHasInventory)inv).func_102007_a(slot, stack, ForgeDirection.UNKNOWN.ordinal());
        }

        @Override
        public boolean insert(IInventory inv, int slot, ItemStack stack) {
            return ((IHasInventory)inv).addStackToSlot(slot, stack);
        }
    }
    ,
    SIDED{

        @Override
        public boolean canHandle(IInventory inv) {
            return inv instanceof ISidedInventory;
        }

        @Override
        public boolean canExtract(IInventory inv, int slot) {
            return ((ISidedInventory)inv).func_102008_b(slot, inv.func_70301_a(slot), ForgeDirection.UNKNOWN.ordinal());
        }

        @Override
        public boolean canInsert(IInventory inv, int slot, ItemStack stack) {
            return ((ISidedInventory)inv).func_102007_a(slot, stack, ForgeDirection.UNKNOWN.ordinal());
        }
    }
    ,
    SIMPLE;

    public static final ImmutableList<InventoryAdapter> ADAPTERS;

    public boolean canHandle(IInventory inv) {
        return inv != null;
    }

    public boolean validate(BlockAnalyzer.IBlockApplyContext context, IInventory inv) {
        return true;
    }

    public int getSizeInventory(IInventory inv) {
        return inv.func_70302_i_();
    }

    public boolean isValidSlot(IInventory inv, int slot) {
        return slot >= 0 && slot < inv.func_70302_i_();
    }

    public boolean canExtract(IInventory inv, int slot) {
        return inv.func_94041_b(slot, inv.func_70301_a(slot));
    }

    public boolean canInsert(IInventory inv, int slot, ItemStack stack) {
        return inv.func_94041_b(slot, stack);
    }

    public ItemStack extract(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        inv.func_70299_a(slot, null);
        return stack;
    }

    public boolean insert(IInventory inv, int slot, ItemStack stack) {
        if (!inv.func_94041_b(slot, stack)) {
            return false;
        }
        if (inv.func_70301_a(slot) != null) {
            return false;
        }
        inv.func_70299_a(slot, stack);
        return true;
    }

    public static InventoryAdapter findAdapter(IInventory inv) {
        for (InventoryAdapter adapter : ADAPTERS) {
            if (!adapter.canHandle(inv)) continue;
            return adapter;
        }
        throw new IllegalStateException();
    }

    static {
        ADAPTERS = ImmutableList.copyOf((Object[])InventoryAdapter.values());
    }
}

