/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.config.GSConfigCore;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityGeothermalGenerator
extends TileBaseUniversalElectricalSource
implements IFluidHandler,
IInventory,
ISidedInventory,
IConnector {
    private static final int MAX_GENERATE_GJ_PER_TICK = 150 * GSConfigCore.coefficientGeothermalGenerator;
    private static final int MIN_GENERATE_GJ_PER_TICK = 60;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank lavaTank = new FluidTank(6000);
    public float prevGenerateWatts = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float heatGJperTick = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int itemCookTime = 0;
    private ItemStack[] containingItems = new ItemStack[1];

    public TileEntityGeothermalGenerator() {
        this.storage.setMaxExtract((float)(MAX_GENERATE_GJ_PER_TICK - 60));
    }

    public int getScaledFuelLevel(int i) {
        return this.lavaTank.getFluidAmount() * i / this.lavaTank.getCapacity();
    }

    public void func_145845_h() {
        if (this.heatGJperTick - 60.0f > 0.0f) {
            this.receiveEnergyGC(null, this.heatGJperTick - 60.0f, false);
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.containingItems[0] != null) {
                if (this.containingItems[0].func_77973_b() == Items.field_151129_at) {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (this.lavaTank.getFluid() == null || this.lavaTank.getFluid().amount + liquid.amount <= this.lavaTank.getCapacity()) {
                        this.lavaTank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                        this.containingItems[0] = new ItemStack(Items.field_151133_ar);
                    }
                } else {
                    boolean isOil;
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (liquid != null && (isOil = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("lava")) && (this.lavaTank.getFluid() == null || this.lavaTank.getFluid().amount + liquid.amount <= this.lavaTank.getCapacity())) {
                        this.lavaTank.fill(new FluidStack(FluidRegistry.LAVA, liquid.amount), true);
                        if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[0]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[0])) {
                            int amount = this.containingItems[0].field_77994_a;
                            if (amount > 1) {
                                this.lavaTank.fill(new FluidStack(FluidRegistry.LAVA, (amount - 1) * 1000), true);
                            }
                            this.containingItems[0] = new ItemStack(Items.field_151133_ar, amount);
                        } else {
                            ItemStack itemStack = this.containingItems[0];
                            --itemStack.field_77994_a;
                            if (this.containingItems[0].field_77994_a == 0) {
                                this.containingItems[0] = null;
                            }
                        }
                    }
                }
            }
            this.produce();
            this.smeltItem();
            this.heatGJperTick = Math.min(Math.max(this.heatGJperTick, 0.0f), this.getMaxEnergyStoredGC());
        }
    }

    public void smeltItem() {
        if (this.canProcess()) {
            this.lavaTank.getFluidAmount();
            this.lavaTank.getCapacity();
            this.lavaTank.getFluidAmount();
            this.lavaTank.drain(1, true);
            this.heatGJperTick = Math.min(this.heatGJperTick + Math.max(this.heatGJperTick * 0.005f, 0.3f), (float)MAX_GENERATE_GJ_PER_TICK);
        }
    }

    public boolean canProcess() {
        if (this.lavaTank.getFluidAmount() > 0) {
            return this.storage.getEnergyStoredGC() < this.storage.getCapacityGC();
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150353_l || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150480_ab) {
            this.heatGJperTick = Math.min(this.heatGJperTick + Math.max(this.heatGJperTick * 0.005f, 0.3f), 90.0f);
            return true;
        }
        this.heatGJperTick = 0.0f;
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemCookTime = nbt.func_74762_e("itemCookTime");
        this.heatGJperTick = nbt.func_74762_e("generateRateInt");
        NBTTagList items = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int index = item.func_74771_c("Slot") & 0xFF;
            if (index >= this.containingItems.length) continue;
            this.containingItems[index] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        if (nbt.func_74764_b("lavaTank")) {
            this.lavaTank.readFromNBT(nbt.func_74775_l("lavaTank"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("itemCookTime", this.itemCookTime);
        nbt.func_74776_a("generateRate", this.heatGJperTick);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.containingItems.length; ++i) {
            if (this.containingItems[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.containingItems[i].func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        if (this.lavaTank.getFluid() != null) {
            nbt.func_74782_a("lavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("Items", (NBTBase)items);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        ItemStack stack = this.containingItems[index].func_77979_a(count);
        if (this.containingItems[index].field_77994_a == 0) {
            this.containingItems[index] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.GeothermalGenerator.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack != null;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack item, int side) {
        return this.func_94041_b(slotID, item);
    }

    public boolean func_102008_b(int slotID, ItemStack item, int side) {
        return slotID == 0;
    }

    public float receiveElectricity(ForgeDirection from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)));
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() + 2));
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return direction != null && !ForgeDirection.UNKNOWN.equals((Object)direction) && type == NetworkType.POWER && direction == this.getElectricalOutputDirectionMain();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite()) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.startsWith("lava")) {
            used = this.lavaTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.lavaTank.getFluid() == null || this.lavaTank.getFluidAmount() < this.lavaTank.getCapacity();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.lavaTank)};
    }
}

