/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.List;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import vswe.stevesfactory.components.LiquidBufferElement;
import vswe.stevesfactory.components.LiquidSetting;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.SlotSideTarget;

public class OutputLiquidCounter {
    private Setting setting;
    private boolean useWhiteList;
    private int currentTankTransferSize;
    private int currentBufferTransferSize;

    public OutputLiquidCounter(List<LiquidBufferElement> liquidBuffer, List<SlotInventoryHolder> tanks, SlotInventoryHolder tank, Setting setting, boolean useWhiteList) {
        block6: {
            this.setting = setting;
            this.useWhiteList = useWhiteList;
            if (setting == null || !setting.isValid() || !setting.isLimitedByAmount()) break block6;
            if (useWhiteList) {
                if (tanks.get(0).isShared()) {
                    for (SlotInventoryHolder slotInventoryHolder : tanks) {
                        this.addTank(setting, slotInventoryHolder);
                    }
                } else {
                    this.addTank(setting, tank);
                }
            } else {
                for (LiquidBufferElement liquidBufferElement : liquidBuffer) {
                    this.currentBufferTransferSize += liquidBufferElement.getBufferSize(setting);
                }
            }
        }
    }

    private void addTank(Setting setting, SlotInventoryHolder tankHolder) {
        int max = 0;
        for (SlotSideTarget slotSideTarget : tankHolder.getValidSlots().values()) {
            for (int side : slotSideTarget.getSides()) {
                FluidStack temp = tankHolder.getTank().drain(ForgeDirection.VALID_DIRECTIONS[side], 10000000, false);
                if (temp == null || temp.getFluidID() != ((LiquidSetting)setting).getLiquidId()) continue;
                max = Math.max(max, temp.amount);
            }
        }
        this.currentTankTransferSize += max;
    }

    public boolean areSettingsSame(Setting setting) {
        return this.setting == null && setting == null || this.setting != null && setting != null && this.setting.getId() == setting.getId();
    }

    public int retrieveItemCount(int desiredItemCount) {
        if (this.setting == null || !this.setting.isLimitedByAmount()) {
            return desiredItemCount;
        }
        int itemsAllowedToBeMoved = this.useWhiteList ? this.setting.getAmount() - this.currentTankTransferSize : this.currentBufferTransferSize - this.setting.getAmount();
        return Math.min(itemsAllowedToBeMoved, desiredItemCount);
    }

    public void modifyStackSize(int itemsToMove) {
        if (this.useWhiteList) {
            this.currentTankTransferSize += itemsToMove;
        } else {
            this.currentBufferTransferSize -= itemsToMove;
        }
    }
}

