/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils.vect;

import forestry.api.farming.FarmDirection;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.MutableVect;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class Vect
implements IVect {
    public final int x;
    public final int y;
    public final int z;

    public Vect(int[] dim) {
        if (dim.length != 3) {
            throw new RuntimeException("Cannot instantiate a vector with less or more than 3 points.");
        }
        this.x = dim[0];
        this.y = dim[1];
        this.z = dim[2];
    }

    public Vect(IVect vect) {
        this.x = vect.getX();
        this.y = vect.getY();
        this.z = vect.getZ();
    }

    public Vect(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
    }

    public Vect(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vect(ChunkCoordinates coordinates) {
        this.x = coordinates.field_71574_a;
        this.y = coordinates.field_71572_b;
        this.z = coordinates.field_71573_c;
    }

    public Vect(TileEntity entity) {
        this.x = entity.field_145851_c;
        this.y = entity.field_145848_d;
        this.z = entity.field_145849_e;
    }

    public Vect(Entity entity) {
        this.x = (int)Math.round(entity.field_70165_t);
        this.y = (int)Math.round(entity.field_70163_u);
        this.z = (int)Math.round(entity.field_70161_v);
    }

    public static Vect getRandomPositionInArea(Random random, IVect area) {
        int x = random.nextInt(area.getX() + 1);
        int y = random.nextInt(area.getY() + 1);
        int z = random.nextInt(area.getZ() + 1);
        return new Vect(x, y, z);
    }

    public static Vect add(IVect ... vects) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (IVect vect : vects) {
            x += vect.getX();
            y += vect.getY();
            z += vect.getZ();
        }
        return new Vect(x, y, z);
    }

    @Override
    public Vect add(IVect other) {
        return new Vect(this.x + other.getX(), this.y + other.getY(), this.z + other.getZ());
    }

    @Override
    public Vect add(int x, int y, int z) {
        return new Vect(this.x + x, this.y + y, this.z + z);
    }

    @Override
    public Vect add(ForgeDirection direction) {
        return this.add(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    @Override
    public Vect add(FarmDirection direction) {
        return this.add(direction.getForgeDirection());
    }

    @Override
    public Vect add(ChunkCoordinates coordinates) {
        return this.add(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c);
    }

    @Override
    public int[] toArray() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public Vect multiply(int factor) {
        return new Vect(this.x * factor, this.y * factor, this.z * factor);
    }

    @Override
    public Vect multiply(float factor) {
        return new Vect(Math.round((float)this.x * factor), Math.round((float)this.y * factor), Math.round((float)this.z * factor));
    }

    public String toString() {
        return String.format("%sx%sx%s", this.x, this.y, this.z);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IVect) {
            IVect other = (IVect)obj;
            return this.x == other.getX() && this.y == other.getY() && this.z == other.getZ();
        }
        return false;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public Vect asImmutable() {
        return this;
    }

    @Override
    public MutableVect asMutable() {
        return new MutableVect(this);
    }
}

