/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.gui.ContainerAlvearySwarmer;
import forestry.apiculture.gui.GuiAlvearySwarmer;
import forestry.apiculture.inventory.InventorySwarmer;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.apiculture.worldgen.Hive;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescriptionSwarmer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileAlvearySwarmer
extends TileAlveary
implements ISidedInventory,
IActivatable,
IAlvearyComponent.Active,
IMultiblockComponent.HasInventory {
    private final InventorySwarmer inventory;
    private final Deque<ItemStack> pendingSpawns = new ArrayDeque<ItemStack>();
    private boolean active;

    public TileAlvearySwarmer() {
        super(BlockAlveary.Type.SWARMER);
        this.inventory = new InventorySwarmer(this);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void updateServer(int tickCount) {
        if (this.pendingSpawns.size() > 0) {
            this.setActive(true);
            if (tickCount % 1000 == 0) {
                this.trySpawnSwarm();
            }
        } else {
            this.setActive(false);
        }
        if (!this.getBeekeepingLogic().canWork()) {
            return;
        }
        if (tickCount % 500 != 0) {
            return;
        }
        ItemStack princessStack = this.getPrincessStack();
        if (princessStack == null) {
            return;
        }
        int chance = this.consumeInducerAndGetChance();
        if (chance == 0) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextInt(1000) >= chance) {
            return;
        }
        IBee princess = BeeManager.beeRoot.getMember(princessStack);
        princess.setIsNatural(false);
        this.pendingSpawns.push(BeeManager.beeRoot.getMemberStack(princess, EnumBeeType.PRINCESS.ordinal()));
    }

    @Override
    public void updateClient(int tickCount) {
    }

    private ItemStack getPrincessStack() {
        ItemStack princessStack = ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeInventory().getQueen();
        if (BeeManager.beeRoot.isMated(princessStack)) {
            return princessStack;
        }
        return null;
    }

    private int consumeInducerAndGetChance() {
        if (this.getInternalInventory() == null) {
            return 0;
        }
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.getInternalInventory())) {
            ItemStack stack = slot.getStackInSlot();
            for (Map.Entry<ItemStack, Integer> entry : BeeManager.inducers.entrySet()) {
                if (!ItemStackUtil.isIdenticalItem(entry.getKey(), stack)) continue;
                slot.decreaseStackInSlot();
                return entry.getValue();
            }
        }
        return 0;
    }

    private void trySpawnSwarm() {
        int chunkZ;
        ItemStack toSpawn = this.pendingSpawns.peek();
        HiveDescriptionSwarmer hiveDescription = new HiveDescriptionSwarmer(toSpawn);
        Hive hive = new Hive(hiveDescription);
        int chunkX = (this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(80) - 40) / 16;
        if (HiveDecorator.genHive(this.field_145850_b, this.field_145850_b.field_73012_v, chunkX, chunkZ = (this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(80) - 40) / 16, hive)) {
            this.pendingSpawns.pop();
        }
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public int getIcon(int side) {
        if (side == 0 || side == 1) {
            return 2;
        }
        if (this.active) {
            return 6;
        }
        return 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setActive(nbttagcompound.func_74767_n("Active"));
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingSpawns", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingSpawns.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("Active", this.active);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[this.pendingSpawns.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingSpawns", (NBTBase)nbttaglist);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.field_145850_b.field_72995_K) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.field_145850_b);
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiAlvearySwarmer(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerAlvearySwarmer(player.field_71071_by, this);
    }
}

