/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.world.World;

public class PacketEffect
extends RailcraftPacket {
    private Effect effect;
    private ByteArrayOutputStream bytes;
    private DataOutputStream outStream;

    public PacketEffect() {
    }

    public PacketEffect(Effect effect) {
        this.effect = effect;
    }

    public DataOutputStream getOutputStream() {
        if (this.outStream == null) {
            this.bytes = new ByteArrayOutputStream();
            this.outStream = new DataOutputStream(this.bytes);
        }
        return this.outStream;
    }

    public void sendPacket(World world, double x, double y, double z) {
        PacketDispatcher.sendToAllAround(this, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 80.0));
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.effect.ordinal());
        data.write(this.bytes.toByteArray());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        EffectManager.instance.handleEffectPacket(data);
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.EFFECT.ordinal();
    }

    public static enum Effect {
        TELEPORT,
        FIRESPARK,
        FORCE_SPAWN;

    }
}

