/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class PlayerPlugin {
    public static final GameProfile RAILCRAFT_USER_PROFILE = new GameProfile(UUID.nameUUIDFromBytes("[Railcraft]".getBytes()), "[Railcraft]");

    public static EntityPlayer getFakePlayer(WorldServer world, double x, double y, double z) {
        FakePlayer player = FakePlayerFactory.get((WorldServer)world, (GameProfile)RAILCRAFT_USER_PROFILE);
        player.func_70107_b(x, y, z);
        return player;
    }

    public static void writeOwnerToNBT(NBTTagCompound nbt, GameProfile owner) {
        if (owner.getName() != null) {
            nbt.func_74778_a("owner", owner.getName());
        }
        if (owner.getId() != null) {
            nbt.func_74778_a("ownerId", owner.getId().toString());
        }
    }

    public static GameProfile readOwnerFromNBT(NBTTagCompound nbt) {
        String ownerName = "[Unknown]";
        if (nbt.func_74764_b("owner")) {
            ownerName = nbt.func_74779_i("owner");
        }
        UUID ownerUUID = null;
        if (nbt.func_74764_b("ownerId")) {
            ownerUUID = UUID.fromString(nbt.func_74779_i("ownerId"));
        }
        return new GameProfile(ownerUUID, ownerName);
    }

    public static String getUsername(World world, GameProfile gameProfile) {
        EntityPlayer player;
        UUID playerId = gameProfile.getId();
        if (playerId != null && (player = world.func_152378_a(playerId)) != null) {
            return player.getDisplayName();
        }
        String username = gameProfile.getName();
        if (username != null && !username.equals("")) {
            return username;
        }
        return "[Unknown]";
    }

    public static String getUsername(World world, UUID playerId) {
        EntityPlayer player;
        if (playerId != null && (player = world.func_152378_a(playerId)) != null) {
            return player.getDisplayName();
        }
        return "[Unknown]";
    }

    public static boolean isOwnerOrOp(GameProfile owner, EntityPlayer player) {
        return PlayerPlugin.isOwnerOrOp(owner, player.func_146103_bH());
    }

    public static boolean isOwnerOrOp(GameProfile owner, GameProfile accessor) {
        if (owner == null || accessor == null) {
            return false;
        }
        if (owner.equals((Object)accessor)) {
            return true;
        }
        return PlayerPlugin.isPlayerOp(accessor);
    }

    public static boolean isSamePlayer(GameProfile a, GameProfile b) {
        if (a.getId() != null && b.getId() != null) {
            return a.getId().equals(b.getId());
        }
        return a.getName() != null && a.getName().equals(b.getName());
    }

    public static boolean isPlayerOp(GameProfile player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new RuntimeException("You derped up! Don't call this on the client!");
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152596_g(player);
    }

    public static boolean isPlayerConnected(GameProfile player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(player.getName()) != null;
    }

    public static void swingItem(EntityPlayer player) {
        player.func_71038_i();
        if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71135_a != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S0BPacketAnimation((Entity)player, 0));
        }
    }
}

