/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.container;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.inventory.ContainerOxygenDistributor;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiOxygenDistributor
extends GuiContainerGC
implements GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation distributorTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/oxygenDistributor.png");
    private final TileEntityOxygenDistributor distributor;
    private final GuiElementInfoRegion oxygenInfoRegion;
    private final GuiElementInfoRegion electricInfoRegion;
    private GuiElementCheckbox checkboxRenderBubble;

    public GuiOxygenDistributor(InventoryPlayer par1InventoryPlayer, TileEntityOxygenDistributor par2TileEntityAirDistributor) {
        super(new ContainerOxygenDistributor(par1InventoryPlayer, par2TileEntityAirDistributor));
        this.oxygenInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 24, 56, 9, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 37, 56, 9, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.distributor = par2TileEntityAirDistributor;
        this.field_147000_g = 180;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 46, (this.field_146295_m - this.field_147000_g) / 2 + 26, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> oxygenSlotDesc = new ArrayList<String>();
        oxygenSlotDesc.add(GCCoreUtil.translate("gui.oxygenSlot.desc.0"));
        oxygenSlotDesc.add(GCCoreUtil.translate("gui.oxygenSlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 16, (this.field_146295_m - this.field_147000_g) / 2 + 26, 18, 18, oxygenSlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> oxygenDesc = new ArrayList<String>();
        oxygenDesc.add(GCCoreUtil.translate("gui.oxygenStorage.desc.0"));
        oxygenDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.oxygenStorage.desc.1") + ": " + (int)Math.floor(this.distributor.storedOxygen) + " / " + (int)Math.floor(this.distributor.maxOxygen));
        this.oxygenInfoRegion.tooltipStrings = oxygenDesc;
        this.oxygenInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.oxygenInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 24;
        this.oxygenInfoRegion.parentWidth = this.field_146294_l;
        this.oxygenInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.oxygenInfoRegion);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
        electricityDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.energyStorage.desc.1") + (int)Math.floor(this.distributor.getEnergyStoredGC()) + " / " + (int)Math.floor(this.distributor.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 37;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        this.checkboxRenderBubble = new GuiElementCheckbox(0, this, var5 + 85, var6 + 87, GCCoreUtil.translate("gui.message.bubbleVisible.name"));
        this.field_146292_n.add(this.checkboxRenderBubble);
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.distributor.func_145825_b(), 8, 10, 0x404040);
        GCCoreUtil.drawStringRightAligned(GCCoreUtil.translate("gui.message.in.name") + ":", 99, 26, 0x404040, this.field_146289_q);
        GCCoreUtil.drawStringRightAligned(GCCoreUtil.translate("gui.message.in.name") + ":", 99, 38, 0x404040, this.field_146289_q);
        String status = GCCoreUtil.translate("gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(status, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(status) / 2, 50, 0x404040);
        status = GCCoreUtil.translate("gui.oxygenUse.desc") + ": " + this.distributor.oxygenPerTick * 20.0f + GCCoreUtil.translate("gui.perSecond");
        this.field_146289_q.func_78276_b(status, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(status) / 2, 60, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("container.inventory"), 8, this.field_147000_g - 90 + 3, 0x404040);
    }

    private String getStatus() {
        if (this.distributor.storedOxygen < this.distributor.oxygenPerTick) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingoxygen.name");
        }
        return this.distributor.getGUIstatus();
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(distributorTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6 + 5, 0, 0, this.field_146999_f, 181);
        if (this.distributor != null) {
            int scale = this.distributor.getCappedScaledOxygenLevel(54);
            this.func_73729_b(var5 + 113, var6 + 25, 197, 7, Math.min(scale, 54), 7);
            scale = this.distributor.getScaledElecticalLevel(54);
            this.func_73729_b(var5 + 113, var6 + 38, 197, 0, Math.min(scale, 54), 7);
            if (this.distributor.getEnergyStoredGC() > 0.0f) {
                this.func_73729_b(var5 + 99, var6 + 37, 176, 0, 11, 10);
            }
            if (this.distributor.storedOxygen > 0.0f) {
                this.func_73729_b(var5 + 100, var6 + 24, 187, 0, 10, 10);
            }
            ArrayList<String> oxygenDesc = new ArrayList<String>();
            oxygenDesc.add(GCCoreUtil.translate("gui.oxygenStorage.desc.0"));
            oxygenDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.oxygenStorage.desc.1") + ": " + (int)Math.floor(this.distributor.storedOxygen) + " / " + (int)Math.floor(this.distributor.maxOxygen));
            this.oxygenInfoRegion.tooltipStrings = oxygenDesc;
            ArrayList<String> electricityDesc = new ArrayList<String>();
            electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
            EnergyDisplayHelper.getEnergyDisplayTooltip(this.distributor.getEnergyStoredGC(), this.distributor.getMaxEnergyStoredGC(), electricityDesc);
            this.electricInfoRegion.tooltipStrings = electricityDesc;
            this.checkboxRenderBubble.isSelected = this.distributor.shouldRenderBubble;
        }
    }

    @Override
    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        this.distributor.setBubbleVisible(newSelected);
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, new Object[]{6, this.distributor.field_145851_c, this.distributor.field_145848_d, this.distributor.field_145849_e, newSelected ? 1 : 0}));
    }

    @Override
    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return this.distributor.shouldRenderBubble;
    }

    @Override
    public void onIntruderInteraction() {
    }
}

