/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.tesla;

import com.google.common.base.Objects;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.tesla.ITeslaConnectable;
import tectech.mechanics.tesla.ITeslaConnectableSimple;

public class TeslaCoverConnection
implements ITeslaConnectableSimple {
    private final IGregTechTileEntity IGT;
    private final Vec3Impl pos;
    private final byte teslaReceptionCapability;

    public TeslaCoverConnection(IGregTechTileEntity IGT, byte teslaReceptionCapability) {
        this.IGT = IGT;
        this.pos = new Vec3Impl(IGT.getXCoord(), (int)IGT.getYCoord(), IGT.getZCoord());
        this.teslaReceptionCapability = teslaReceptionCapability;
    }

    @Override
    public byte getTeslaReceptionCapability() {
        return this.teslaReceptionCapability;
    }

    @Override
    public float getTeslaReceptionCoefficient() {
        return 1.0f;
    }

    @Override
    public boolean isTeslaReadyToReceive() {
        return true;
    }

    @Override
    public long getTeslaStoredEnergy() {
        return this.IGT.getStoredEU();
    }

    @Override
    public Vec3Impl getTeslaPosition() {
        return this.pos;
    }

    @Override
    public Integer getTeslaDimension() {
        return this.IGT.getWorld().field_73011_w.field_76574_g;
    }

    @Override
    public boolean teslaInjectEnergy(long teslaVoltageInjected) {
        boolean output = false;
        if (!this.IGT.isDead()) {
            output = this.IGT.injectEnergyUnits(ForgeDirection.UP, teslaVoltageInjected, 1L) > 0L;
        } else {
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemoveScheduled(this);
        }
        return output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeslaCoverConnection that = (TeslaCoverConnection)o;
        return Objects.equal((Object)this.IGT, (Object)that.IGT);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.IGT});
    }
}

