/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.machines;

import gtPlusPlus.core.fluids.GTPPFluids;
import gtPlusPlus.core.tileentities.machines.TileEntityBaseFluidCollector;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class TileEntityPooCollector
extends TileEntityBaseFluidCollector {
    private static final ArrayList<Class> aEntityToDrain = new ArrayList();

    public TileEntityPooCollector() {
        super(9, 8000);
    }

    @Override
    public void onPreLogicTick() {
    }

    @Override
    public <V> boolean addDrop(V aPooMaker) {
        int aChance = MathUtils.randInt(0, 50000);
        if (aChance > 0) {
            ItemStack aPoop;
            if (aChance <= 100) {
                aPoop = GregtechItemList.ManureByproductsDust.get(1L, new Object[0]);
            } else if (aChance <= 500) {
                aPoop = GregtechItemList.SmallManureByproductsDust.get(1L, new Object[0]);
            } else if (aChance <= 1250) {
                aPoop = GregtechItemList.TinyManureByproductsDust.get(1L, new Object[0]);
            } else {
                return false;
            }
            if (aPoop == null) {
                return false;
            }
            if (!this.mInventory.addItemStack(aPoop)) {
                EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d + 1.5, (double)this.field_145849_e, aPoop);
                this.field_145850_b.func_72838_d((Entity)entity);
            }
        }
        return false;
    }

    @Override
    public ArrayList<Class> aThingsToLookFor() {
        if (aEntityToDrain.isEmpty()) {
            aEntityToDrain.add(EntityAnimal.class);
            aEntityToDrain.add(IAnimals.class);
        }
        return aEntityToDrain;
    }

    @Override
    public <V> int onPostTick(V aPooMaker) {
        if (this.tank.getFluidAmount() < this.tank.getCapacity()) {
            int aPooAmount = 0;
            aPooAmount = aPooMaker instanceof EntityChicken ? MathUtils.randInt(1, 40) : (aPooMaker instanceof EntityHorse ? MathUtils.randInt(20, 40) : (aPooMaker instanceof EntityCow ? MathUtils.randInt(18, 45) : (aPooMaker instanceof EntityMooshroom ? 17 : (aPooMaker instanceof EntitySheep ? MathUtils.randInt(8, 30) : (aPooMaker instanceof IAnimals ? MathUtils.randInt(5, 35) : MathUtils.randInt(1, 10))))));
            aPooAmount = Math.max(Math.min(this.tank.getCapacity() - this.tank.getFluidAmount(), aPooAmount) / 10, 1);
            return aPooAmount;
        }
        return 0;
    }

    @Override
    public Fluid fluidToProvide() {
        return GTPPFluids.PoopJuice;
    }

    @Override
    public ItemStack itemToSpawnInWorldIfTankIsFull() {
        int a = MathUtils.randInt(0, 100);
        ItemStack aItem = null;
        if (a <= 30) {
            aItem = GregtechItemList.DriedEarthDust.get(1L, new Object[0]);
        } else if (a <= 40) {
            aItem = GregtechItemList.SmallManureByproductsDust.get(1L, new Object[0]);
        } else if (a <= 55) {
            aItem = GregtechItemList.TinyManureByproductsDust.get(1L, new Object[0]);
        }
        return aItem;
    }
}

