/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTByteBuffer;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.ChestUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class CoverChest
extends Cover {
    private final int slots;
    private final int stackSizeLimit = 1;
    private LimitingItemStackHandler items;
    private boolean firstTick;

    public CoverChest(CoverContext context, int slots, ITexture coverTexture) {
        super(context, coverTexture);
        if (slots <= 0) {
            throw new IllegalArgumentException("slots must be greater than 0");
        }
        this.slots = slots;
        this.items = new LimitingItemStackHandler(slots, 1);
    }

    public int getSlotCount() {
        return this.slots;
    }

    public IItemHandlerModifiable getItems() {
        return this.items;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        if (!(nbt instanceof NBTTagCompound)) {
            return;
        }
        this.items.deserializeNBT((NBTTagCompound)nbt);
        this.firstTick = true;
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        this.items.deserializeNBT(GTByteBuffer.readCompoundTagFromGreggyByteBuf(byteData));
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        return this.items.serializeNBT();
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)this.items.serializeNBT());
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean allowsCopyPasteTool() {
        return false;
    }

    @Override
    public boolean allowsTickRateAddition() {
        return false;
    }

    @Override
    public void onCoverRemoval() {
        ICoverable iCoverable = (ICoverable)this.coveredTile.get();
        if (iCoverable == null || iCoverable.getWorld().field_72995_K) {
            return;
        }
        this.dropAll(iCoverable, this.coverSide);
    }

    private void dropAll(ICoverable coverable, ForgeDirection direction) {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack tItem = this.items.getStackInSlot(i);
            if (tItem == null) continue;
            CoverChest.dropItem(coverable, direction, tItem);
            this.items.setStackInSlot(i, null);
        }
    }

    @Override
    public int getMinimumTickRate() {
        return this.firstTick ? 1 : 0;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (this.items.getSlots() != this.slots) {
            if (this.items.getSlots() > this.slots) {
                for (int i = this.slots; i < this.items.getSlots(); ++i) {
                    ItemStack item = this.items.getStackInSlot(i);
                    if (item == null) continue;
                    CoverChest.dropItem(coverable, this.coverSide, item);
                }
            }
            this.items = new LimitingItemStackHandler(this.slots, 1);
            int toCopy = Math.min(this.items.getSlots(), this.items.getSlots());
            for (int i = 0; i < toCopy; ++i) {
                this.items.setStackInSlot(i, this.items.getStackInSlot(i));
            }
        }
        this.firstTick = false;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ChestUIFactory(buildContext).createWindow();
    }

    private static void dropItem(ICoverable coverable, ForgeDirection direction, ItemStack tItem) {
        EntityItem tItemEntity = new EntityItem(coverable.getWorld(), (double)((float)coverable.getXCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f + (float)direction.offsetX), (double)((float)coverable.getYCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f + (float)direction.offsetY), (double)((float)coverable.getZCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f + (float)direction.offsetZ), new ItemStack(tItem.func_77973_b(), tItem.field_77994_a, tItem.func_77960_j()));
        if (tItem.func_77942_o()) {
            tItemEntity.func_92059_d().func_77982_d((NBTTagCompound)tItem.func_77978_p().func_74737_b());
        }
        tItemEntity.field_70159_w = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
        tItemEntity.field_70181_x = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05 + 0.2;
        tItemEntity.field_70179_y = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
        tItemEntity.field_70172_ad = 999999;
        tItemEntity.lifespan = 60000;
        coverable.getWorld().func_72838_d((Entity)tItemEntity);
    }

    private static class LimitingItemStackHandler
    extends ItemStackHandler {
        private final int slotLimit;

        private LimitingItemStackHandler(int slots, int slotLimit) {
            super(slots);
            this.slotLimit = slotLimit;
        }

        public int getSlotLimit(int slot) {
            return this.slotLimit;
        }
    }
}

