/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.threads;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IMachineBlockUpdateable;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.MTEFrame;
import gregtech.api.threads.RunnableCableUpdate;
import gregtech.common.config.Gregtech;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RunnableMachineUpdate
implements Runnable {
    protected final int initialX;
    protected final int initialY;
    protected final int initialZ;
    protected final World world;
    protected final LongSet visited = new LongOpenHashSet();
    protected final LongArrayFIFOQueue tQueue = new LongArrayFIFOQueue();
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread thread = new Thread(r);
        thread.setName("GT_MachineBlockUpdate");
        return thread;
    };
    private static ExecutorService EXECUTOR_SERVICE;
    private static final Semaphore SEMAPHORE;
    private static final AtomicInteger TASK_COUNTER;
    protected static boolean isEnabled;
    protected static final ThreadLocal<Boolean> perThreadEnable;

    protected RunnableMachineUpdate(World aWorld, int posX, int posY, int posZ) {
        this.world = aWorld;
        this.initialX = posX;
        this.initialY = posY;
        this.initialZ = posZ;
        long coords = CoordinatePacker.pack((int)posX, (int)posY, (int)posZ);
        this.visited.add(coords);
        this.tQueue.enqueue(coords);
    }

    public static void onBeforeTickLockLocked() {
        int numTasks = TASK_COUNTER.get();
        if (numTasks > 0) {
            try {
                SEMAPHORE.acquire(numTasks);
                TASK_COUNTER.addAndGet(-numTasks);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onAfterTickLockReleased() {
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled() {
        isEnabled = true;
    }

    public static void setDisabled() {
        isEnabled = false;
    }

    public static void setEnabled(boolean isEnabled) {
        RunnableMachineUpdate.isEnabled = isEnabled;
    }

    public static boolean isCurrentThreadEnabled() {
        return perThreadEnable.get();
    }

    public static void setCurrentThreadEnabled(boolean perThreadEnable) {
        RunnableMachineUpdate.perThreadEnable.set(perThreadEnable);
    }

    public static void setMachineUpdateValues(World aWorld, int posX, int posY, int posZ) {
        if (RunnableMachineUpdate.isEnabled() && RunnableMachineUpdate.isCurrentThreadEnabled()) {
            RunnableMachineUpdate.postTaskToRun(new RunnableMachineUpdate(aWorld, posX, posY, posZ));
        }
    }

    protected static void postTaskToRun(Runnable runnable) {
        CompletableFuture<Void> f = CompletableFuture.runAsync(runnable, EXECUTOR_SERVICE);
        TASK_COUNTER.incrementAndGet();
        f.thenRun(SEMAPHORE::release);
    }

    public static void initExecutorService() {
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() * 2 / 3), THREAD_FACTORY);
    }

    public static void shutdownExecutorService() {
        try {
            GTMod.GT_FML_LOGGER.info("Shutting down Machine block update executor service");
            EXECUTOR_SERVICE.shutdown();
            if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                EXECUTOR_SERVICE.shutdownNow();
                if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                    GTMod.GT_FML_LOGGER.error("Well this didn't terminated well... RunnableMachineUpdate.shutdownExecutorService");
                }
            }
        }
        catch (InterruptedException ie) {
            GTMod.GT_FML_LOGGER.error("Well this interruption got interrupted...", (Throwable)ie);
            EXECUTOR_SERVICE.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            GTMod.GT_FML_LOGGER.error("Well this didn't terminated well...", (Throwable)e);
            EXECUTOR_SERVICE.shutdownNow();
        }
        finally {
            GTMod.GT_FML_LOGGER.info("Leaving... RunnableMachineUpdate.shutdownExecutorService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList<BMPEdata> adjacentCableList = new LinkedList<BMPEdata>();
        LongOpenHashSet adjacentCableKeys = new LongOpenHashSet();
        try {
            while (!this.tQueue.isEmpty()) {
                boolean isBaseMetaPipeEntity;
                boolean isMachineBlock;
                TileEntity tTileEntity;
                long packedCoords = this.tQueue.dequeueLong();
                int posX = CoordinatePacker.unpackX((long)packedCoords);
                int posY = CoordinatePacker.unpackY((long)packedCoords);
                int posZ = CoordinatePacker.unpackZ((long)packedCoords);
                GTMod.proxy.TICK_LOCK.lock();
                try {
                    tTileEntity = this.world.func_147438_o(posX, posY, posZ);
                    isMachineBlock = GregTechAPI.isMachineBlock(this.world.func_147439_a(posX, posY, posZ), this.world.func_72805_g(posX, posY, posZ));
                }
                finally {
                    GTMod.proxy.TICK_LOCK.unlock();
                }
                if (tTileEntity instanceof IMachineBlockUpdateable) {
                    ((IMachineBlockUpdateable)tTileEntity).onMachineBlockUpdate();
                }
                if (Gregtech.features.speedupMachineUpdateThread && (isBaseMetaPipeEntity = tTileEntity instanceof BaseMetaPipeEntity)) {
                    BMPEdata bmpeData = new BMPEdata((BaseMetaPipeEntity)tTileEntity, posX, posY, posZ);
                    adjacentCableKeys.add(packedCoords);
                    adjacentCableList.add(bmpeData);
                    if (!bmpeData.isPotentialStructureBlock) continue;
                }
                if (this.visited.size() >= 5 && (!(tTileEntity instanceof IMachineBlockUpdateable) || !((IMachineBlockUpdateable)tTileEntity).isMachineBlockUpdateRecursive()) && !isMachineBlock) continue;
                for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                    ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[i];
                    long tCoords = CoordinatePacker.pack((int)(posX + side.offsetX), (int)(posY + side.offsetY), (int)(posZ + side.offsetZ));
                    if (!this.visited.add(tCoords)) continue;
                    this.tQueue.enqueue(tCoords);
                }
            }
            for (BMPEdata cable : adjacentCableList) {
                if (!cable.isMetaPipe) continue;
                for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                    long targetCoords;
                    ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[i];
                    if (!cable.metaPipe.isConnectedAtSide(side) || adjacentCableKeys.contains(targetCoords = CoordinatePacker.pack((int)(cable.x + side.offsetX), (int)(cable.y + side.offsetY), (int)(cable.z + side.offsetZ))) || !this.visited.contains(targetCoords)) continue;
                    RunnableCableUpdate.setCableUpdateValues(this.world, cable.x, cable.y, cable.z);
                }
            }
        }
        catch (Exception e) {
            GTMod.GT_FML_LOGGER.error("Well this update was broken... " + this.initialX + ", " + this.initialY + ", " + this.initialZ + ", mWorld={" + this.world.func_72827_u() + " @dimId " + this.world.field_73011_w.field_76574_g + "}", (Throwable)e);
        }
    }

    static {
        SEMAPHORE = new Semaphore(Integer.MAX_VALUE);
        TASK_COUNTER = new AtomicInteger(0);
        isEnabled = true;
        perThreadEnable = ThreadLocal.withInitial(() -> true);
    }

    private static class BMPEdata {
        final int x;
        final int y;
        final int z;
        final BaseMetaPipeEntity baseMetaPipe;
        final IMetaTileEntity metaTile;
        final MetaPipeEntity metaPipe;
        final boolean isMetaPipe;
        final boolean isPotentialStructureBlock;

        BMPEdata(BaseMetaPipeEntity bmpe, int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.baseMetaPipe = bmpe;
            this.metaTile = this.baseMetaPipe.getMetaTileEntity();
            this.isMetaPipe = this.metaTile instanceof MetaPipeEntity;
            this.metaPipe = this.isMetaPipe ? (MetaPipeEntity)this.metaTile : null;
            this.isPotentialStructureBlock = this.metaPipe instanceof MTEFrame;
        }
    }
}

