/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.filters;

import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.item.ItemStack;

public class ArrayStackFilter
implements IStackFilter {
    private final ItemStack[] stacks;
    private final boolean matchNBT;
    private final boolean matchMetadata;

    public ArrayStackFilter(ItemStack ... stacks) {
        this(false, false, stacks);
    }

    public ArrayStackFilter(boolean matchNBT, boolean matchMetadata, ItemStack ... stacks) {
        this.matchNBT = matchNBT;
        this.matchMetadata = matchMetadata;
        this.stacks = stacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (this.stacks.length == 0 || !this.hasFilter()) {
            return true;
        }
        for (ItemStack filterStack : this.stacks) {
            if (!InvTools.isItemEqual(stack, filterStack, false, this.matchNBT, this.matchMetadata)) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getStacks() {
        return this.stacks;
    }

    public boolean hasFilter() {
        for (ItemStack filter : this.stacks) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }
}

