/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.research;

import minetweaker.IUndoableAction;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;

public class AddResearch
implements IUndoableAction {
    String key;
    String tab;
    ResearchItem research;
    ResearchItem oldResearch;
    ItemStack[] itemTriggers;
    String[] entityTriggers;
    AspectList aspectTriggers;

    public AddResearch(ResearchItem res, ItemStack[] itemTriggers, String[] entityTriggers, AspectList aspectTriggers) {
        this.research = res;
        this.tab = this.research.category;
        this.key = this.research.key;
        this.itemTriggers = itemTriggers;
        this.entityTriggers = entityTriggers;
        this.aspectTriggers = aspectTriggers;
    }

    public void apply() {
        this.oldResearch = ResearchCategories.getResearch((String)this.research.key);
        if (this.itemTriggers != null) {
            this.research = this.research.setItemTriggers(this.itemTriggers);
        }
        if (this.entityTriggers != null) {
            this.research = this.research.setEntityTriggers(this.entityTriggers);
        }
        if (this.aspectTriggers != null) {
            this.research = this.research.setAspectTriggers(this.aspectTriggers.getAspects());
        }
        this.research.registerResearchItem();
    }

    public String describe() {
        return "Registering Research: " + this.key;
    }

    public boolean canUndo() {
        return this.tab != null && this.key != null;
    }

    public void undo() {
        if (this.oldResearch == null) {
            ((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)this.tab)).research.remove(this.key);
        } else {
            ((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)this.tab)).research.put(this.key, this.oldResearch);
        }
    }

    public String describeUndo() {
        return "Removing Research: " + this.key;
    }

    public String getOverrideKey() {
        return null;
    }
}

