/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.util;

import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockBreakHelper {
    private BlockBreakHelper() {
    }

    public static boolean isWrenchableBlock(Block block, EntityPlayer player) {
        return block instanceof IWrenchable && ((IWrenchable)block).wrenchCanRemove(player);
    }

    public static boolean tryBreakWrenchable(World world, EntityPlayer player, int x, int y, int z, Block block, int blockMeta, double dropX, double dropY, double dropZ) {
        if (block instanceof IWrenchable && ((IWrenchable)block).wrenchCanRemove(player)) {
            ItemStack wrenchedStack = ((IWrenchable)block).getWrenchDrop(player);
            block.func_149749_a(world, x, y, z, block, blockMeta);
            world.func_147468_f(x, y, z);
            EntityItem drop = new EntityItem(world, dropX, dropY, dropZ, wrenchedStack);
            world.func_72838_d((Entity)drop);
            return true;
        }
        return false;
    }

    public static boolean isBlockBreakableWithHeldTool(Block block, int meta, EntityPlayer player) {
        return block.canHarvestBlock(player, meta);
    }

    public static boolean tryBreakHeldTool(World world, EntityPlayer player, int blockX, int blockY, int blockZ, Block block, int blockMeta, double dropX, double dropY, double dropZ, Random random) {
        if (block.canHarvestBlock(player, blockMeta)) {
            ArrayList items = block.getDrops(world, blockX, blockY, blockZ, blockMeta, 0);
            float dropChance = ForgeEventFactory.fireBlockHarvesting((ArrayList)items, (World)world, (Block)block, (int)blockX, (int)blockY, (int)blockZ, (int)blockMeta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player);
            for (ItemStack droppedStack : items) {
                if (!(random.nextFloat() <= dropChance)) continue;
                EntityItem drop = new EntityItem(world, dropX, dropY, dropZ, droppedStack);
                world.func_72838_d((Entity)drop);
            }
            block.func_149749_a(world, blockX, blockY, blockZ, block, blockMeta);
            world.func_147468_f(blockX, blockY, blockZ);
            return true;
        }
        return false;
    }
}

