/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.network;

import baubles.api.IBauble;
import baubles.common.Baubles;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public class PacketSyncBauble
implements IMessage,
IMessageHandler<PacketSyncBauble, IMessage> {
    int slot;
    int playerId;
    ItemStack bauble = null;
    boolean initial;

    public PacketSyncBauble() {
    }

    public PacketSyncBauble(EntityPlayer player, int slot) {
        this(player, slot, false);
    }

    public PacketSyncBauble(EntityPlayer player, int slot, boolean reset) {
        this.slot = slot;
        this.bauble = PlayerHandler.getPlayerBaubles(player).func_70301_a(slot);
        this.playerId = player.func_145782_y();
        this.initial = reset;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.slot);
        buffer.writeInt(this.playerId);
        buffer.writeBoolean(this.initial);
        PacketBuffer pb = new PacketBuffer(buffer);
        try {
            pb.func_150788_a(this.bauble);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.slot = buffer.readByte();
        this.playerId = buffer.readInt();
        this.initial = buffer.readBoolean();
        PacketBuffer pb = new PacketBuffer(buffer);
        try {
            this.bauble = pb.func_150791_c();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IMessage onMessage(PacketSyncBauble message, MessageContext ctx) {
        World world = Baubles.proxy.getClientWorld();
        if (world == null) {
            return null;
        }
        Entity e = world.func_73045_a(message.playerId);
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles(player);
            if (message.initial) {
                Item item;
                if (message.slot == 0) {
                    PlayerHandler.clearClientPlayerBaubles();
                    baubles = PlayerHandler.getPlayerBaubles(player);
                }
                baubles.stackList[message.slot] = message.bauble;
                if (message.bauble != null && (item = message.bauble.func_77973_b()) instanceof IBauble) {
                    IBauble itemBauble = (IBauble)item;
                    itemBauble.onPlayerLoad(message.bauble, (EntityLivingBase)player);
                }
            } else {
                baubles.func_70299_a(message.slot, message.bauble);
            }
        }
        return null;
    }
}

