/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.common.FMLLog;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.blocks.BlockEntitySignal;
import tuhljin.automagy.items.ItemEntityEye;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class TileEntityEntitySignal
extends ModTileEntityWithInventory {
    public static final int TICK_CHECK_RATE = 4;
    public static final int DETECT_RADIUS = 5;
    public boolean filterAdults = true;
    public boolean filterChildren = true;
    public boolean specificPlayer = false;
    public int powerStability;
    private String mobName = "";
    private boolean isPlayer = false;
    private int ticksSinceCheck = 0;
    private double minX;
    private double minY = -1.0;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    public TileEntityEntitySignal() {
        super("blockEntitySignal", 1);
        this.notifyOnInventoryChanged = true;
    }

    public String getMobName() {
        return this.mobName;
    }

    private void updateMobName() {
        ItemStack stack = this.func_70301_a(0);
        this.mobName = stack != null && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("mobName") ? stack.field_77990_d.func_74779_i("mobName") : "";
        this.isPlayer = stack != null && stack.field_77990_d != null && stack.field_77990_d.func_74767_n("entityIsPlayer");
    }

    @Override
    public int func_70297_j_() {
        return super.func_70297_j_();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return ItemEntityEye.hasLinkedMob(stack);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prevStack) {
        this.updateMobName();
    }

    public void receiveGUIMessage(int type, int data) {
        switch (type) {
            case 0: {
                this.filterAdults = data == 1;
                break;
            }
            case 1: {
                this.filterChildren = data == 1;
                break;
            }
            case 2: {
                this.specificPlayer = data == 1;
                break;
            }
            default: {
                FMLLog.warning((String)("[Automagy] TileEntityEntitySignal received invalid packet data. Ignoring. (type=" + type + ")"), (Object[])new Object[0]);
                return;
            }
        }
        this.markDirty(false);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74757_a("filterAdults", this.filterAdults);
        nbttagcompound.func_74757_a("filterChildren", this.filterChildren);
        nbttagcompound.func_74757_a("specificPlayer", this.specificPlayer);
        nbttagcompound.func_74777_a("powerStability", (short)this.powerStability);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.filterAdults = nbttagcompound.func_74767_n("filterAdults");
        this.filterChildren = nbttagcompound.func_74767_n("filterChildren");
        this.specificPlayer = nbttagcompound.func_74767_n("specificPlayer");
        this.powerStability = nbttagcompound.func_74765_d("powerStability");
        this.updateMobName();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksSinceCheck < 4) {
                ++this.ticksSinceCheck;
            } else {
                this.ticksSinceCheck = 0;
                if (!this.mobName.isEmpty()) {
                    if (this.minY == -1.0) {
                        this.calculateRange();
                    }
                    AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
                    List entities = this.field_145850_b.func_82733_a(EntityLivingBase.class, box, (IEntitySelector)new EntitySelectorByName());
                    this.setPowerLevel(entities.size());
                } else {
                    this.setPowerLevel(0);
                }
            }
        }
    }

    private void setPowerLevel(int power) {
        int md = this.func_145832_p();
        int oldStability = this.powerStability;
        this.powerStability = Math.max(0, power - 15);
        power = Math.min(power, 15);
        if (this.powerStability != oldStability) {
            this.func_70296_d();
        }
        if (power != md) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, power, 3);
        } else if (this.powerStability != oldStability) {
            NeighborNotifier.notifyBlocksOfExtendedNeighborChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    private void calculateRange() {
        boolean edgeXn = BlockEntitySignal.isScanBlockedBy((IBlockAccess)this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, ForgeDirection.WEST);
        boolean edgeXp = BlockEntitySignal.isScanBlockedBy((IBlockAccess)this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, ForgeDirection.EAST);
        boolean edgeYn = BlockEntitySignal.isScanBlockedBy((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, ForgeDirection.DOWN);
        boolean edgeYp = BlockEntitySignal.isScanBlockedBy((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ForgeDirection.UP);
        boolean edgeZn = BlockEntitySignal.isScanBlockedBy((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, ForgeDirection.NORTH);
        boolean edgeZp = BlockEntitySignal.isScanBlockedBy((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, ForgeDirection.SOUTH);
        this.minX = edgeXn ? (double)this.field_145851_c : (double)(this.field_145851_c - 5);
        this.minY = edgeYn ? (double)this.field_145848_d : (double)(this.field_145848_d - 5);
        double d = this.minZ = edgeZn ? (double)this.field_145849_e : (double)(this.field_145849_e - 5);
        if (edgeXp) {
            this.maxX = this.field_145851_c + 1;
            if (!edgeXn) {
                this.minX -= 5.0;
            }
        } else {
            this.maxX = this.field_145851_c + 1 + 5;
            if (edgeXn) {
                this.maxX += 5.0;
            }
        }
        if (edgeYp) {
            this.maxY = this.field_145848_d + 1;
            if (!edgeYn) {
                this.minY -= 5.0;
            }
        } else {
            this.maxY = this.field_145848_d + 1 + 5;
            if (edgeYn) {
                this.maxY += 5.0;
            }
        }
        if (edgeZp) {
            this.maxZ = this.field_145849_e + 1;
            if (!edgeZn) {
                this.minZ -= 5.0;
            }
        } else {
            this.maxZ = this.field_145849_e + 1 + 5;
            if (edgeZn) {
                this.maxZ += 5.0;
            }
        }
        if (this.minY < 0.0) {
            this.minY = 0.0;
        }
    }

    public void flagRangeForRecalculation() {
        this.minY = -1.0;
    }

    public class EntitySelectorByName
    implements IEntitySelector {
        public boolean func_82704_a(Entity entity) {
            if (entity instanceof EntityLivingBase) {
                if (entity instanceof EntityPlayer) {
                    if (TileEntityEntitySignal.this.isPlayer) {
                        if (!TileEntityEntitySignal.this.specificPlayer) {
                            return true;
                        }
                        String name = entity.func_70005_c_();
                        if (TileEntityEntitySignal.this.mobName.equals(name)) {
                            return true;
                        }
                    }
                } else {
                    String name = EntityList.func_75621_b((Entity)entity);
                    if (TileEntityEntitySignal.this.mobName.equals(name)) {
                        if (entity instanceof EntityAgeable) {
                            if (((EntityAgeable)entity).func_70631_g_()) {
                                return TileEntityEntitySignal.this.filterChildren;
                            }
                            return TileEntityEntitySignal.this.filterAdults;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

