/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.events;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.IWandTriggerManager;
import thaumcraft.api.wands.WandTriggerRegistry;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockChestHungry;
import thaumcraft.common.blocks.BlockMagicalLog;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.foci.ItemFocusPortableHole;
import thaumcraft.common.tiles.TileJarNode;
import thaumcraft.common.tiles.TileOwned;
import thaumcraft.common.tiles.TileWarded;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.config.ModRecipes;
import tuhljin.automagy.lib.AutomagyConfig;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.network.MessageParticles;

public class WandEventManager
implements IWandTriggerManager {
    private static final int REACT_OBSIDIAN = 0;
    private static final int REACT_WARDEDBLOCK = 1;

    public WandEventManager() {
        WandTriggerRegistry.registerWandBlockTrigger((IWandTriggerManager)this, (int)0, (Block)Blocks.field_150343_Z, (int)0, (String)"Automagy");
        if (AutomagyConfig.allowAdvNodeJarring) {
            WandTriggerRegistry.registerWandBlockTrigger((IWandTriggerManager)this, (int)1, (Block)ConfigBlocks.blockWarded, (int)-1, (String)"Automagy");
        }
    }

    public boolean performTrigger(World world, ItemStack wand, EntityPlayer player, int x, int y, int z, int side, int event) {
        switch (event) {
            case 0: {
                if (!ThaumcraftExtension.isResearchComplete(player, "HUNGRYMAW") || !this.transformObsidian(world, wand, player, x, y, z)) break;
                return false;
            }
            case 1: {
                if (!ThaumcraftExtension.isResearchComplete(player, "ADVNODEJAR")) break;
                return this.attemptJarNode(world, wand, player, x, y, z);
            }
        }
        return false;
    }

    public boolean attemptJarNode(World world, ItemStack wandStack, EntityPlayer player, int x, int y, int z) {
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        if (wand.getFocus(wandStack) != null) {
            return false;
        }
        for (int xx = x - 2; xx <= x; ++xx) {
            for (int yy = y - 3; yy <= y; ++yy) {
                for (int zz = z - 2; zz <= z; ++zz) {
                    if (!this.isAdvJarStructureAt(world, xx, yy, zz, player)) continue;
                    if (ThaumcraftApiHelper.consumeVisFromWandCrafting((ItemStack)wandStack, (EntityPlayer)player, (AspectList)ModRecipes.visCostAdvNodeJar, (boolean)true)) {
                        if (!world.field_72995_K) {
                            this.createAdvJarFromStructure(world, xx, yy, zz);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public boolean transformObsidian(World world, ItemStack wand, EntityPlayer player, int x, int y, int z) {
        Block b;
        if (ThaumcraftExtension.getWandFocus(wand) instanceof ItemFocusPortableHole && (b = world.func_147439_a(x, y - 1, z)) instanceof BlockChestHungry) {
            if (!world.field_72995_K) {
                MessageParticles.sendToClients(world, x, y - 1, z, 0, 0, 0, (short)0);
                world.func_147465_d(x, y - 1, z, (Block)ModBlocks.specialProcessBlock, 0, 3);
            } else {
                for (int i = 0; i < 10; ++i) {
                    Thaumcraft.proxy.wispFX3(world, (double)((float)x + 0.5f + world.field_73012_v.nextFloat() / 2.0f), (double)((float)y - 0.5f + world.field_73012_v.nextFloat() / 2.0f), (double)((float)z + 0.5f + world.field_73012_v.nextFloat() / 2.0f), (double)((float)x + 0.3f + world.field_73012_v.nextFloat() * 0.4f), (double)((float)y + 0.5f), (double)((float)z + 0.3f + world.field_73012_v.nextFloat() * 0.4f), 0.5f, 5, true, -0.025f);
                    Thaumcraft.proxy.wispFX3(world, (double)((float)x + 0.5f - world.field_73012_v.nextFloat() / 2.0f), (double)((float)y - 0.5f - world.field_73012_v.nextFloat() / 2.0f), (double)((float)z + 0.5f - world.field_73012_v.nextFloat() / 2.0f), (double)((float)x + 0.3f + world.field_73012_v.nextFloat() * 0.4f), (double)((float)y + 0.5f), (double)((float)z + 0.3f + world.field_73012_v.nextFloat() * 0.4f), 0.5f, 5, true, -0.025f);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isWardedSilverwoodLog(World world, int x, int y, int z, EntityPlayer pOwner) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileWarded) {
            TileWarded warded = (TileWarded)te;
            if (warded.block == ConfigBlocks.blockMagicalLog && BlockMagicalLog.limitToValidMetadata((int)warded.blockMd) == 1) {
                return pOwner.func_70005_c_().hashCode() == warded.owner;
            }
        }
        return false;
    }

    private boolean isWardedGlass(World world, int x, int y, int z, EntityPlayer pOwner) {
        TileEntity te;
        if (world.func_147439_a(x, y, z) == ConfigBlocks.blockCosmeticOpaque && world.func_72805_g(x, y, z) == 2 && (te = world.func_147438_o(x, y, z)) instanceof TileOwned) {
            return pOwner.func_70005_c_().equals(((TileOwned)te).owner);
        }
        return false;
    }

    private boolean isAdvJarStructureAt(World world, int x, int y, int z, EntityPlayer pOwner) {
        int[][][] blueprint = new int[][][]{new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 3, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}};
        for (int yy = 0; yy < 4; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    TileEntity tile;
                    int index = blueprint[yy][xx][zz];
                    if (!(index == 1 ? !this.isWardedSilverwoodLog(world, x + xx, y - yy + 2, z + zz, pOwner) : (index == 2 ? !this.isWardedGlass(world, x + xx, y - yy + 2, z + zz, pOwner) : index == 3 && ((tile = world.func_147438_o(x + xx, y - yy + 2, z + zz)) == null || !(tile instanceof INode) || tile instanceof TileJarNode)))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void createAdvJarFromStructure(World world, int x, int y, int z) {
        int[][][] blueprint = new int[][][]{new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 3, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}};
        for (int yy = 0; yy < 4; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    int index = blueprint[yy][xx][zz];
                    if (index == 3) {
                        TileEntity tile = world.func_147438_o(x + xx, y - yy + 2, z + zz);
                        INode node = (INode)tile;
                        AspectList na = node.getAspects().copy();
                        int nt = node.getNodeType().ordinal();
                        int nm = -1;
                        if (node.getNodeModifier() != null) {
                            nm = node.getNodeModifier().ordinal();
                        }
                        String nid = node.getId();
                        node.setAspects(new AspectList());
                        world.func_147475_p(x + xx, y - yy + 2, z + zz);
                        world.func_147465_d(x + xx, y - yy + 2, z + zz, ConfigBlocks.blockJar, 2, 3);
                        tile = world.func_147438_o(x + xx, y - yy + 2, z + zz);
                        TileJarNode jar = (TileJarNode)tile;
                        jar.setAspects(na);
                        if (nm >= 0) {
                            jar.setNodeModifier(NodeModifier.values()[nm]);
                        }
                        jar.setNodeType(NodeType.values()[nt]);
                        jar.setId(nid);
                        world.func_147452_c(x + xx, y - yy + 2, z + zz, ConfigBlocks.blockJar, 9, 0);
                        continue;
                    }
                    world.func_147468_f(x + xx, y - yy + 2, z + zz);
                }
            }
        }
    }
}

