/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.liquid;

import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.liquid.EnderLiquidStorage;
import codechicken.enderstorage.storage.liquid.TankSynchroniser;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEnderTank
extends TileFrequencyOwner
implements IFluidHandler {
    private static Cuboid6[] selectionBoxes = new Cuboid6[4];
    public static Transformation[] buttonT = new Transformation[3];
    public int rotation;
    public EnderTankState liquid_state = new EnderTankState();
    public PressureState pressure_state = new PressureState();
    private EnderLiquidStorage storage;
    private boolean described;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.pressure_state.update(this.field_145850_b.field_72995_K);
        if (this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.field_145850_b.field_72995_K);
    }

    private void ejectLiquid() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            int qty;
            TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (!(t instanceof IFluidHandler)) continue;
            IFluidHandler c = (IFluidHandler)t;
            FluidStack liquid = this.drain(null, 100, false);
            if (liquid == null || (qty = c.fill(side.getOpposite(), liquid, true)) <= 0) continue;
            this.drain(null, qty, true);
        }
    }

    @Override
    public void reloadStorage() {
        this.storage = (EnderLiquidStorage)EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.owner, this.freq, "liquid");
        if (!this.field_145850_b.field_72995_K) {
            this.liquid_state.reloadStorage(this.storage);
        }
    }

    @Override
    public EnderLiquidStorage getStorage() {
        return this.storage;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.storage.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.storage.drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.storage.drain(from, resource, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.storage.canDrain(from, fluid);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.storage.canFill(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.field_145850_b.field_72995_K) {
            return new FluidTankInfo[]{new FluidTankInfo(this.liquid_state.s_liquid, EnderLiquidStorage.CAPACITY)};
        }
        return this.storage.getTankInfo(from);
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        tag.func_74757_a("ir", this.pressure_state.invert_redstone);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.rotation = tag.func_74771_c("rot");
        this.pressure_state.invert_redstone = tag.func_74767_n("ir");
    }

    @Override
    public void writeToPacket(PacketCustom packet) {
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom desc) {
        super.handleDescriptionPacket(desc);
        this.rotation = desc.readUByte();
        this.liquid_state.s_liquid = desc.readFluidStack();
        this.pressure_state.a_pressure = desc.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        ItemStack held = player.func_71045_bC();
        if (held == null) {
            return false;
        }
        if (held.func_77973_b() instanceof IFluidContainerItem && this.handleIFCI(player, held)) {
            return true;
        }
        if (this.handleFCFullToEmpty(player, held)) {
            return true;
        }
        return this.handleFCEmptyToFull(player, held);
    }

    private boolean handleIFCI(EntityPlayer player, ItemStack held) {
        int canFill;
        int wantMove;
        int capacity;
        int remaining;
        FluidStack currentFluid;
        FluidStack simDrain;
        int tankCan;
        int wantMove2;
        FluidStack inCell;
        IFluidContainerItem cont = (IFluidContainerItem)held.func_77973_b();
        ItemStack target = held;
        boolean split = false;
        if (held.field_77994_a > 1) {
            target = held.func_77946_l();
            target.field_77994_a = 1;
            split = true;
        }
        if ((inCell = cont.getFluid(target)) != null && inCell.amount > 0 && (wantMove2 = Math.min(tankCan = this.fill(null, inCell, false), inCell.amount)) > 0 && (simDrain = cont.drain(target, wantMove2, false)) != null && simDrain.amount > 0) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            if (player.field_71075_bZ.field_75098_d) {
                this.fill(null, new FluidStack(simDrain.getFluid(), simDrain.amount), true);
                return true;
            }
            FluidStack drained = cont.drain(target, simDrain.amount, true);
            if (drained != null && drained.amount > 0) {
                this.fill(null, drained, true);
                if (split) {
                    --held.field_77994_a;
                    TileEnderTank.giveOrDrop(player, target);
                }
                TileEnderTank.syncInv(player);
            }
            return true;
        }
        FluidStack tankFluid = this.storage.getFluid();
        if (tankFluid != null && tankFluid.getFluid() != null && ((currentFluid = cont.getFluid(target)) == null || currentFluid.getFluid() == tankFluid.getFluid()) && (remaining = (capacity = cont.getCapacity(target)) - (currentFluid != null ? currentFluid.amount : 0)) > 0 && (wantMove = Math.min(remaining, tankFluid.amount)) > 0 && (canFill = cont.fill(target, new FluidStack(tankFluid.getFluid(), wantMove), false)) > 0) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            if (player.field_71075_bZ.field_75098_d) {
                FluidStack pulled = this.drain(null, canFill, true);
                return pulled != null && pulled.amount > 0;
            }
            FluidStack pulled = this.drain(null, canFill, true);
            if (pulled != null && pulled.amount > 0) {
                int filled = cont.fill(target, pulled, true);
                int leftover = pulled.amount - filled;
                if (leftover > 0) {
                    this.fill(null, new FluidStack(pulled.getFluid(), leftover), true);
                }
                if (filled > 0) {
                    if (split) {
                        --held.field_77994_a;
                        TileEnderTank.giveOrDrop(player, target);
                    }
                    TileEnderTank.syncInv(player);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean handleFCFullToEmpty(EntityPlayer player, ItemStack held) {
        ItemStack single = held.func_77946_l();
        single.field_77994_a = 1;
        FluidStack offered = FluidContainerRegistry.getFluidForFilledItem((ItemStack)single);
        if (offered == null || offered.amount <= 0) {
            return false;
        }
        if (this.fill(null, offered, false) < offered.amount) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        this.fill(null, offered, true);
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack empty;
            --held.field_77994_a;
            if (held.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            if ((empty = FluidContainerRegistry.drainFluidContainer((ItemStack)single)) != null) {
                TileEnderTank.giveOrDrop(player, empty);
            }
            TileEnderTank.syncInv(player);
        }
        return true;
    }

    private boolean handleFCEmptyToFull(EntityPlayer player, ItemStack held) {
        FluidStack tankFluid = this.storage.getFluid();
        if (tankFluid == null || tankFluid.getFluid() == null) {
            return false;
        }
        ItemStack singleEmpty = held.func_77946_l();
        singleEmpty.field_77994_a = 1;
        ItemStack preview = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(tankFluid.getFluid(), tankFluid.amount), (ItemStack)singleEmpty);
        if (preview == null) {
            return false;
        }
        FluidStack inside = FluidContainerRegistry.getFluidForFilledItem((ItemStack)preview);
        if (inside == null || inside.amount <= 0) {
            return false;
        }
        int unit = inside.amount;
        FluidStack can = this.drain(null, unit, false);
        if (can == null || can.amount < unit) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        this.drain(null, unit, true);
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (held.field_77994_a > 1) {
            --held.field_77994_a;
            TileEnderTank.giveOrDrop(player, preview);
        } else {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, preview);
        }
        TileEnderTank.syncInv(player);
        return true;
    }

    private static void giveOrDrop(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        boolean added = player.field_71071_by.func_70441_a(stack);
        if (!added) {
            player.func_71019_a(stack, false);
        }
    }

    private static void syncInv(EntityPlayer player) {
        player.field_71071_by.func_70296_d();
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            mp.field_71069_bz.func_75142_b();
            mp.func_71120_a(mp.field_71069_bz);
        }
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        Vector3 pos = new Vector3((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6(0.15, 0.0, 0.15, 0.85, 0.916, 0.85).add(pos)));
        for (int i = 0; i < 4; ++i) {
            cuboids.add(new IndexedCuboid6((Object)(i + 1), selectionBoxes[i].copy().apply(Rotation.quarterRotations[this.rotation ^ 2].at(Vector3.center)).add(pos)));
        }
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.amount > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.amount / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    public void sync(PacketCustom packet) {
        if (packet.getType() == 5) {
            this.liquid_state.sync(packet.readFluidStack());
        } else if (packet.getType() == 6) {
            this.pressure_state.a_pressure = packet.readBoolean();
        }
    }

    @Override
    public boolean rotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.func_145844_m(), (World)this.field_145850_b, (int)(this.field_145851_c >> 4), (int)(this.field_145849_e >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        FluidTankInfo tank = this.storage.getTankInfo(null)[0];
        return tank.fluid.amount * 14 / tank.capacity + (tank.fluid.amount > 0 ? 1 : 0);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderTank.buttonT[i] = new Scale(0.6).with((Transformation)new Translation(0.35 + (double)i * 0.15, 0.91, 0.5));
            TileEnderTank.selectionBoxes[i] = selection_button.copy().apply(buttonT[i]);
        }
        TileEnderTank.selectionBoxes[3] = new Cuboid6(0.358, 0.268, 0.05, 0.662, 0.565, 0.15);
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                boolean bl = this.a_pressure = TileEnderTank.this.field_145850_b.func_72864_z(TileEnderTank.this.field_145851_c, TileEnderTank.this.field_145848_d, TileEnderTank.this.field_145849_e) != this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90.0 : 90.0;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 6);
            packet.writeCoord(TileEnderTank.this.field_145851_c, TileEnderTank.this.field_145848_d, TileEnderTank.this.field_145849_e);
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk(TileEnderTank.this.field_145850_b, TileEnderTank.this.field_145851_c >> 4, TileEnderTank.this.field_145849_e >> 4);
        }

        public void invert() {
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.field_145850_b.func_72938_d(TileEnderTank.this.field_145851_c, TileEnderTank.this.field_145849_e).func_76630_e();
        }
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 5);
            packet.writeCoord(TileEnderTank.this.field_145851_c, TileEnderTank.this.field_145848_d, TileEnderTank.this.field_145849_e);
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk(TileEnderTank.this.field_145850_b, TileEnderTank.this.field_145851_c >> 4, TileEnderTank.this.field_145849_e >> 4);
        }

        @Override
        public void onLiquidChanged() {
            TileEnderTank.this.field_145850_b.func_147451_t(TileEnderTank.this.field_145851_c, TileEnderTank.this.field_145848_d, TileEnderTank.this.field_145849_e);
        }
    }
}

