/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.items.interfaces;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public interface IBindable {
    default public boolean checkRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (this.toggle(par1ItemStack, par2World, par3EntityPlayer)) {
            return true;
        }
        if (par2World.field_72995_K) {
            return true;
        }
        if (!IBindable.isActive(par1ItemStack) || SpellHelper.isFakePlayer(par2World, par3EntityPlayer)) {
            return true;
        }
        if (this.isBoundTool() && AlchemicalWizardry.disableBoundToolsRightClick) {
            return true;
        }
        if (par3EntityPlayer.func_70644_a(AlchemicalWizardry.customPotionInhibit)) {
            return true;
        }
        return !par3EntityPlayer.field_71075_bZ.field_75098_d && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.rightClickCost());
    }

    default public void addBindingInformation(ItemStack par1ItemStack, List par3List) {
        NBTTagCompound itemTag = IBindable.getTag(par1ItemStack);
        if (itemTag.func_74767_n("isActive")) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.activated"));
        } else if (itemTag.func_74764_b("isActive")) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.deactivated"));
        }
        if (!itemTag.func_74779_i("ownerName").equals("")) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + itemTag.func_74779_i("ownerName"));
        }
    }

    public static void setActive(ItemStack par1ItemStack, boolean state) {
        NBTTagCompound itemTag = IBindable.getTag(par1ItemStack);
        itemTag.func_74757_a("isActive", state);
    }

    public static boolean isActive(ItemStack par1ItemStack) {
        NBTTagCompound itemTag = IBindable.getTag(par1ItemStack);
        return itemTag.func_74767_n("isActive");
    }

    public static NBTTagCompound getTag(ItemStack par1ItemStack) {
        NBTTagCompound itemTag = par1ItemStack.func_77978_p();
        if (itemTag == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
            itemTag = par1ItemStack.func_77978_p();
        }
        return itemTag;
    }

    default public boolean toggle(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!IBindable.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.func_70093_af()) {
            IBindable.setActive(par1ItemStack, !IBindable.isActive(par1ItemStack));
            this.setDrainTick(par1ItemStack, par2World);
            return true;
        }
        return false;
    }

    default public boolean checkPassiveDrain(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        NBTTagCompound itemTag = IBindable.getTag(par1ItemStack);
        if (par2World.func_82737_E() % (long)this.drainTicks() == (long)itemTag.func_74762_e("worldTimeDelay") && itemTag.func_74767_n("isActive")) {
            this.doPassiveDrain(par1ItemStack, par3EntityPlayer);
            return true;
        }
        return false;
    }

    default public void doPassiveDrain(ItemStack par1ItemStack, EntityPlayer par3EntityPlayer) {
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.drainCost())) {
            IBindable.setActive(par1ItemStack, false);
        }
    }

    default public void setDrainTick(ItemStack par1ItemStack, World par2World) {
        IBindable.getTag(par1ItemStack).func_74768_a("worldTimeDelay", (int)(par2World.func_82737_E() - 1L) % this.drainTicks());
    }

    public static boolean checkAndSetItemOwner(ItemStack item, EntityPlayer player) {
        return !SpellHelper.isFakePlayer(player) && SoulNetworkHandler.checkAndSetItemPlayer(item, player);
    }

    public static void setItemOwner(ItemStack item, String ownerName) {
        NBTTagCompound tag = IBindable.getTag(item);
        tag.func_74778_a("ownerName", ownerName);
    }

    public static void checkAndSetItemOwner(ItemStack item, String ownerName) {
        NBTTagCompound tag = IBindable.getTag(item);
        if (tag.func_74779_i("ownerName").isEmpty()) {
            tag.func_74778_a("ownerName", ownerName);
        }
    }

    public static String getOwnerName(ItemStack item) {
        NBTTagCompound tag = IBindable.getTag(item);
        return tag.func_74779_i("ownerName");
    }

    default public int drainTicks() {
        return 200;
    }

    default public boolean isBoundTool() {
        return false;
    }

    default public int rightClickCost() {
        return 0;
    }

    default public int drainCost() {
        return 0;
    }
}

