/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.guihook;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

final class HideousLinkedList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = -8504433551965776915L;
    private final List<E> backing;

    HideousLinkedList(List<E> backing) {
        this.backing = backing;
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.backing.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.backing.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backing.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.backing.add(e);
    }

    @Override
    public void addFirst(E e) {
        this.backing.add(0, e);
    }

    @Override
    public E getFirst() {
        if (this.backing.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.backing.get(0);
    }

    @Override
    public E removeFirst() {
        E item = this.getFirst();
        this.backing.remove(0);
        return item;
    }

    @Override
    public void addLast(E e) {
        this.backing.add(this.backing.size(), e);
    }

    @Override
    public E getLast() {
        if (this.backing.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.backing.get(this.backing.size() - 1);
    }

    @Override
    public E removeLast() {
        E item = this.getLast();
        this.backing.remove(this.backing.size() - 1);
        return item;
    }

    @Override
    public E peek() {
        return this.backing.size() > 0 ? (E)this.backing.get(0) : null;
    }

    @Override
    public E peekFirst() {
        return this.backing.size() > 0 ? (E)this.getFirst() : null;
    }

    @Override
    public E peekLast() {
        return this.backing.size() > 0 ? (E)this.getLast() : null;
    }

    @Override
    public E poll() {
        return this.backing.size() > 0 ? (E)this.removeFirst() : null;
    }

    @Override
    public E pollFirst() {
        return this.poll();
    }

    @Override
    public E pollLast() {
        return this.backing.size() > 0 ? (E)this.removeLast() : null;
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object e) {
        return this.remove(e);
    }

    @Override
    public boolean removeLastOccurrence(Object e) {
        int idx = this.backing.lastIndexOf(e);
        if (idx != -1) {
            this.backing.remove(idx);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.backing.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backing.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.backing.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.backing.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.backing.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.backing.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        this.backing.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.backing.sort(c);
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.backing.equals(o);
    }

    @Override
    public int hashCode() {
        return this.backing.hashCode();
    }

    @Override
    public E get(int index) {
        return this.backing.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.backing.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.backing.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.backing.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.backing.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.backing.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.backing.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.backing.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.backing.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.backing.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.backing.removeIf(filter);
    }

    @Override
    public Stream<E> stream() {
        return this.backing.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.backing.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.backing.forEach(action);
    }
}

