/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntitySignalFlare;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.ModItems;

public class ItemSignalFlare
extends ItemMod {
    IIcon[] icons;
    private static final String TAG_COLOR = "color";

    public ItemSignalFlare() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77656_e(200);
        this.func_77655_b("signalFlare");
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77960_j() == 0) {
            if (world.field_72995_K) {
                player.func_71038_i();
            } else {
                EntitySignalFlare flare = new EntitySignalFlare(world);
                flare.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                flare.setColor(ItemSignalFlare.getColor(stack));
                world.func_72956_a((Entity)player, "random.explode", 40.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                world.func_72838_d((Entity)flare);
                int stunned = 0;
                int range = 5;
                List entities = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)range), (double)(player.field_70163_u - (double)range), (double)(player.field_70161_v - (double)range), (double)(player.field_70165_t + (double)range), (double)(player.field_70163_u + (double)range), (double)(player.field_70161_v + (double)range)));
                for (EntityLivingBase entity : entities) {
                    if (entity == player || entity instanceof EntityPlayer && MinecraftServer.func_71276_C() != null && !MinecraftServer.func_71276_C().func_71219_W()) continue;
                    entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 50, 5));
                    ++stunned;
                }
                if (stunned >= 100) {
                    player.func_71064_a((StatBase)ModAchievements.signalFlareStun, 1);
                }
            }
            stack.func_77972_a(200, (EntityLivingBase)player);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
        if (stack.func_77951_h()) {
            stack.func_77964_b(stack.func_77960_j() - 1);
        }
    }

    @Override
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[2];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = IconHelper.forItem(register, (Item)this, i);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons[Math.min(1, pass)];
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 0) {
            return 0xFFFFFF;
        }
        int colorv = ItemSignalFlare.getColor(stack);
        if (colorv >= EntitySheep.field_70898_d.length || colorv < 0) {
            return 0xFFFFFF;
        }
        float[] color = EntitySheep.field_70898_d[ItemSignalFlare.getColor(stack)];
        return new Color(color[0], color[1], color[2]).getRGB();
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            list.add(ItemSignalFlare.forColor(i));
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> infoList, boolean advanced) {
        int storedColor = ItemSignalFlare.getColor(stack);
        infoList.add(String.format(StatCollector.func_74838_a((String)"botaniamisc.flareColor"), StatCollector.func_74838_a((String)("botania.color" + storedColor))));
    }

    public static ItemStack forColor(int color) {
        ItemStack stack = new ItemStack(ModItems.signalFlare);
        ItemNBTHelper.setInt(stack, TAG_COLOR, color);
        return stack;
    }

    public static int getColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR, 0xFFFFFF);
    }
}

