/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.thaumcraft;

import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.glease.tc4tweak.modules.generateItemHash.GenerateItemHash;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.embeddedt.archaicfix.ArchaicLogger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.client.gui.GuiResearchRecipe;

public class MappingsHandler {
    public static HashMultimap<String, List<?>> fastMap = null;

    public static void handle() {
        ArchaicLogger.LOGGER.info("Beginning mapping generation");
        ArrayList<ItemStack> allStacks = new ArrayList<ItemStack>();
        for (Object o : GameData.getBlockRegistry()) {
            Block block = (Block)o;
            for (int meta = 0; meta < 16; ++meta) {
                allStacks.add(new ItemStack(block, 1, meta));
            }
        }
        for (Object o : GameData.getItemRegistry()) {
            Item item = (Item)o;
            try {
                item.func_150895_a(item, item.func_77640_w(), allStacks);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        allStacks.removeIf(stack -> stack == null || stack.func_77973_b() == null);
        ArchaicLogger.LOGGER.info("Collected list of all item stacks - " + allStacks.size());
        HashMultimap theMultimap = HashMultimap.create();
        for (List entry : ThaumcraftApi.objectTags.keySet()) {
            if (entry.get(1) instanceof int[]) {
                Arrays.sort((int[])entry.get(1));
            }
            theMultimap.put((Object)((Item)entry.get(0)).func_77658_a(), (Object)entry);
        }
        fastMap = theMultimap;
        ArchaicLogger.LOGGER.info("Collected list of object tags - " + GuiResearchRecipe.cache.size() + " cache entries");
        allStacks.parallelStream().forEach(stack -> {
            try {
                GuiResearchRecipe.putToCache((int)GenerateItemHash.generateItemHash((Item)stack.func_77973_b(), (int)stack.func_77960_j()), (ItemStack)stack.func_77946_l());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ArchaicLogger.LOGGER.info("Successfully generated item hashes - " + GuiResearchRecipe.cache.size() + " cache entries");
        fastMap = null;
        if (GuiResearchRecipe.cache.size() == 0) {
            throw new IllegalStateException("No item hashes at all? How did we get here?");
        }
    }
}

