/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import remoteio.common.core.TabRemoteIO;
import remoteio.common.lib.ModInfo;
import remoteio.common.tile.TileMachineHeater;
import remoteio.common.tile.TileMachineReservoir;
import remoteio.common.tile.core.TileCore;

public class BlockMachine
extends BlockContainer {
    public static IIcon[] icons;
    public static IIcon[] overlays;

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(TabRemoteIO.TAB);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileCore tile;
        if (!world.field_72995_K && (tile = (TileCore)world.func_147438_o(x, y, z)) != null) {
            tile.onNeighborUpdated();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            ItemStack held = player.func_70694_bm();
            if (held != null && held.field_77994_a == 1) {
                if (held.func_77973_b() instanceof IFluidContainerItem) {
                    if (!world.field_72995_K) {
                        IFluidContainerItem fluidContainerItem = (IFluidContainerItem)held.func_77973_b();
                        fluidContainerItem.fill(held, new FluidStack(FluidRegistry.WATER, fluidContainerItem.getCapacity(held)), true);
                    }
                    return true;
                }
                if (FluidContainerRegistry.isEmptyContainer((ItemStack)held)) {
                    ItemStack filled;
                    if (!world.field_72995_K && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(FluidRegistry.WATER, FluidContainerRegistry.getContainerCapacity((ItemStack)held)), (ItemStack)held)) != null) {
                        player.func_70062_b(0, filled);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public IIcon func_149691_a(int side, int meta) {
        return icons[meta];
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof TileMachineReservoir) {
                return ((TileMachineReservoir)tile).filled ? icons[0] : icons[2];
            }
            if (tile instanceof TileMachineHeater) {
                return ((TileMachineHeater)tile).filled ? icons[1] : icons[2];
            }
        }
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    public void func_149651_a(IIconRegister register) {
        icons = new IIcon[3];
        BlockMachine.icons[0] = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "reservoir");
        BlockMachine.icons[1] = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "heater");
        BlockMachine.icons[2] = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "machine_inactive");
        overlays = new IIcon[2];
        BlockMachine.overlays[0] = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "overlay/reservoir");
        BlockMachine.overlays[1] = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "overlay/heater");
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileMachineReservoir();
            }
            case 1: {
                return new TileMachineHeater();
            }
        }
        return null;
    }
}

